package zio.aws.firehose.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.firehose.model.primitives.{
  DeliveryStreamName,
  ListDeliveryStreamsInputLimit
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListDeliveryStreamsRequest(
    limit: Optional[ListDeliveryStreamsInputLimit] = Optional.Absent,
    deliveryStreamType: Optional[zio.aws.firehose.model.DeliveryStreamType] =
      Optional.Absent,
    exclusiveStartDeliveryStreamName: Optional[DeliveryStreamName] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.ListDeliveryStreamsRequest = {
    import ListDeliveryStreamsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.ListDeliveryStreamsRequest
      .builder()
      .optionallyWith(
        limit.map(value => ListDeliveryStreamsInputLimit.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(deliveryStreamType.map(value => value.unwrap))(
        _.deliveryStreamType
      )
      .optionallyWith(
        exclusiveStartDeliveryStreamName.map(value =>
          DeliveryStreamName.unwrap(value): java.lang.String
        )
      )(_.exclusiveStartDeliveryStreamName)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.ListDeliveryStreamsRequest.ReadOnly =
    zio.aws.firehose.model.ListDeliveryStreamsRequest.wrap(buildAwsValue())
}
object ListDeliveryStreamsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.ListDeliveryStreamsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.ListDeliveryStreamsRequest =
      zio.aws.firehose.model.ListDeliveryStreamsRequest(
        limit.map(value => value),
        deliveryStreamType.map(value => value),
        exclusiveStartDeliveryStreamName.map(value => value)
      )
    def limit: Optional[ListDeliveryStreamsInputLimit]
    def deliveryStreamType: Optional[zio.aws.firehose.model.DeliveryStreamType]
    def exclusiveStartDeliveryStreamName: Optional[DeliveryStreamName]
    def getLimit: ZIO[Any, AwsError, ListDeliveryStreamsInputLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getDeliveryStreamType
        : ZIO[Any, AwsError, zio.aws.firehose.model.DeliveryStreamType] =
      AwsError.unwrapOptionField("deliveryStreamType", deliveryStreamType)
    def getExclusiveStartDeliveryStreamName
        : ZIO[Any, AwsError, DeliveryStreamName] = AwsError.unwrapOptionField(
      "exclusiveStartDeliveryStreamName",
      exclusiveStartDeliveryStreamName
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.ListDeliveryStreamsRequest
  ) extends zio.aws.firehose.model.ListDeliveryStreamsRequest.ReadOnly {
    override val limit: Optional[ListDeliveryStreamsInputLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.limit())
        .map(value =>
          zio.aws.firehose.model.primitives.ListDeliveryStreamsInputLimit(value)
        )
    override val deliveryStreamType
        : Optional[zio.aws.firehose.model.DeliveryStreamType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deliveryStreamType())
        .map(value => zio.aws.firehose.model.DeliveryStreamType.wrap(value))
    override val exclusiveStartDeliveryStreamName
        : Optional[DeliveryStreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.exclusiveStartDeliveryStreamName())
      .map(value => zio.aws.firehose.model.primitives.DeliveryStreamName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.ListDeliveryStreamsRequest
  ): zio.aws.firehose.model.ListDeliveryStreamsRequest.ReadOnly = new Wrapper(
    impl
  )
}
