package zio.aws.firehose.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.firehose.model.primitives.{
  ListTagsForDeliveryStreamInputLimit,
  TagKey,
  DeliveryStreamName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListTagsForDeliveryStreamRequest(
    deliveryStreamName: DeliveryStreamName,
    exclusiveStartTagKey: Optional[TagKey] = Optional.Absent,
    limit: Optional[ListTagsForDeliveryStreamInputLimit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.ListTagsForDeliveryStreamRequest = {
    import ListTagsForDeliveryStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.ListTagsForDeliveryStreamRequest
      .builder()
      .deliveryStreamName(
        DeliveryStreamName.unwrap(deliveryStreamName): java.lang.String
      )
      .optionallyWith(
        exclusiveStartTagKey.map(value =>
          TagKey.unwrap(value): java.lang.String
        )
      )(_.exclusiveStartTagKey)
      .optionallyWith(
        limit.map(value =>
          ListTagsForDeliveryStreamInputLimit.unwrap(value): Integer
        )
      )(_.limit)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.ListTagsForDeliveryStreamRequest.ReadOnly =
    zio.aws.firehose.model.ListTagsForDeliveryStreamRequest
      .wrap(buildAwsValue())
}
object ListTagsForDeliveryStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.ListTagsForDeliveryStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.ListTagsForDeliveryStreamRequest =
      zio.aws.firehose.model.ListTagsForDeliveryStreamRequest(
        deliveryStreamName,
        exclusiveStartTagKey.map(value => value),
        limit.map(value => value)
      )
    def deliveryStreamName: DeliveryStreamName
    def exclusiveStartTagKey: Optional[TagKey]
    def limit: Optional[ListTagsForDeliveryStreamInputLimit]
    def getDeliveryStreamName: ZIO[Any, Nothing, DeliveryStreamName] =
      ZIO.succeed(deliveryStreamName)
    def getExclusiveStartTagKey: ZIO[Any, AwsError, TagKey] =
      AwsError.unwrapOptionField("exclusiveStartTagKey", exclusiveStartTagKey)
    def getLimit: ZIO[Any, AwsError, ListTagsForDeliveryStreamInputLimit] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.ListTagsForDeliveryStreamRequest
  ) extends zio.aws.firehose.model.ListTagsForDeliveryStreamRequest.ReadOnly {
    override val deliveryStreamName: DeliveryStreamName =
      zio.aws.firehose.model.primitives
        .DeliveryStreamName(impl.deliveryStreamName())
    override val exclusiveStartTagKey: Optional[TagKey] = zio.aws.core.internal
      .optionalFromNullable(impl.exclusiveStartTagKey())
      .map(value => zio.aws.firehose.model.primitives.TagKey(value))
    override val limit: Optional[ListTagsForDeliveryStreamInputLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.limit())
        .map(value =>
          zio.aws.firehose.model.primitives
            .ListTagsForDeliveryStreamInputLimit(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.ListTagsForDeliveryStreamRequest
  ): zio.aws.firehose.model.ListTagsForDeliveryStreamRequest.ReadOnly =
    new Wrapper(impl)
}
