package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  NonEmptyString,
  NonEmptyStringWithoutWhitespace,
  BooleanObject
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OpenXJsonSerDe(
    convertDotsInJsonKeysToUnderscores: Optional[BooleanObject] =
      Optional.Absent,
    caseInsensitive: Optional[BooleanObject] = Optional.Absent,
    columnToJsonKeyMappings: Optional[
      Map[NonEmptyStringWithoutWhitespace, NonEmptyString]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.OpenXJsonSerDe = {
    import OpenXJsonSerDe.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.OpenXJsonSerDe
      .builder()
      .optionallyWith(
        convertDotsInJsonKeysToUnderscores.map(value =>
          value: java.lang.Boolean
        )
      )(_.convertDotsInJsonKeysToUnderscores)
      .optionallyWith(caseInsensitive.map(value => value: java.lang.Boolean))(
        _.caseInsensitive
      )
      .optionallyWith(
        columnToJsonKeyMappings.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyStringWithoutWhitespace
                .unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.columnToJsonKeyMappings)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.OpenXJsonSerDe.ReadOnly =
    zio.aws.firehose.model.OpenXJsonSerDe.wrap(buildAwsValue())
}
object OpenXJsonSerDe {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.OpenXJsonSerDe
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.OpenXJsonSerDe =
      zio.aws.firehose.model.OpenXJsonSerDe(
        convertDotsInJsonKeysToUnderscores.map(value => value),
        caseInsensitive.map(value => value),
        columnToJsonKeyMappings.map(value => value)
      )
    def convertDotsInJsonKeysToUnderscores: Optional[BooleanObject]
    def caseInsensitive: Optional[BooleanObject]
    def columnToJsonKeyMappings
        : Optional[Map[NonEmptyStringWithoutWhitespace, NonEmptyString]]
    def getConvertDotsInJsonKeysToUnderscores
        : ZIO[Any, AwsError, BooleanObject] = AwsError.unwrapOptionField(
      "convertDotsInJsonKeysToUnderscores",
      convertDotsInJsonKeysToUnderscores
    )
    def getCaseInsensitive: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("caseInsensitive", caseInsensitive)
    def getColumnToJsonKeyMappings: ZIO[Any, AwsError, Map[
      NonEmptyStringWithoutWhitespace,
      NonEmptyString
    ]] = AwsError.unwrapOptionField(
      "columnToJsonKeyMappings",
      columnToJsonKeyMappings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.OpenXJsonSerDe
  ) extends zio.aws.firehose.model.OpenXJsonSerDe.ReadOnly {
    override val convertDotsInJsonKeysToUnderscores: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.convertDotsInJsonKeysToUnderscores())
        .map(value => value: BooleanObject)
    override val caseInsensitive: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.caseInsensitive())
        .map(value => value: BooleanObject)
    override val columnToJsonKeyMappings
        : Optional[Map[NonEmptyStringWithoutWhitespace, NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.columnToJsonKeyMappings())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.firehose.model.primitives.NonEmptyStringWithoutWhitespace(
                key
              ) -> zio.aws.firehose.model.primitives.NonEmptyString(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.OpenXJsonSerDe
  ): zio.aws.firehose.model.OpenXJsonSerDe.ReadOnly = new Wrapper(impl)
}
