package zio.aws.firehose.model
import scala.jdk.CollectionConverters.*
sealed trait OrcCompression {
  def unwrap: software.amazon.awssdk.services.firehose.model.OrcCompression
}
object OrcCompression {
  def wrap(
      value: software.amazon.awssdk.services.firehose.model.OrcCompression
  ): zio.aws.firehose.model.OrcCompression = value match {
    case software.amazon.awssdk.services.firehose.model.OrcCompression.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.firehose.model.OrcCompression.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.firehose.model.OrcCompression.ZLIB =>
      val r = ZLIB
      r
    case software.amazon.awssdk.services.firehose.model.OrcCompression.SNAPPY =>
      val r = SNAPPY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.firehose.model.OrcCompression {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.OrcCompression =
      software.amazon.awssdk.services.firehose.model.OrcCompression.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.firehose.model.OrcCompression {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.OrcCompression =
      software.amazon.awssdk.services.firehose.model.OrcCompression.NONE
  }
  case object ZLIB extends zio.aws.firehose.model.OrcCompression {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.OrcCompression =
      software.amazon.awssdk.services.firehose.model.OrcCompression.ZLIB
  }
  case object SNAPPY extends zio.aws.firehose.model.OrcCompression {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.OrcCompression =
      software.amazon.awssdk.services.firehose.model.OrcCompression.SNAPPY
  }
}
