package zio.aws.firehose.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.firehose.model.primitives.{
  NonNegativeIntegerObject,
  BooleanObject,
  ParquetPageSizeBytes,
  BlockSizeBytes
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ParquetSerDe(
    blockSizeBytes: Optional[BlockSizeBytes] = Optional.Absent,
    pageSizeBytes: Optional[ParquetPageSizeBytes] = Optional.Absent,
    compression: Optional[zio.aws.firehose.model.ParquetCompression] =
      Optional.Absent,
    enableDictionaryCompression: Optional[BooleanObject] = Optional.Absent,
    maxPaddingBytes: Optional[NonNegativeIntegerObject] = Optional.Absent,
    writerVersion: Optional[zio.aws.firehose.model.ParquetWriterVersion] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.ParquetSerDe = {
    import ParquetSerDe.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.ParquetSerDe
      .builder()
      .optionallyWith(
        blockSizeBytes.map(value => BlockSizeBytes.unwrap(value): Integer)
      )(_.blockSizeBytes)
      .optionallyWith(
        pageSizeBytes.map(value => ParquetPageSizeBytes.unwrap(value): Integer)
      )(_.pageSizeBytes)
      .optionallyWith(compression.map(value => value.unwrap))(_.compression)
      .optionallyWith(
        enableDictionaryCompression.map(value => value: java.lang.Boolean)
      )(_.enableDictionaryCompression)
      .optionallyWith(
        maxPaddingBytes.map(value =>
          NonNegativeIntegerObject.unwrap(value): Integer
        )
      )(_.maxPaddingBytes)
      .optionallyWith(writerVersion.map(value => value.unwrap))(_.writerVersion)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.ParquetSerDe.ReadOnly =
    zio.aws.firehose.model.ParquetSerDe.wrap(buildAwsValue())
}
object ParquetSerDe {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.ParquetSerDe
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.ParquetSerDe =
      zio.aws.firehose.model.ParquetSerDe(
        blockSizeBytes.map(value => value),
        pageSizeBytes.map(value => value),
        compression.map(value => value),
        enableDictionaryCompression.map(value => value),
        maxPaddingBytes.map(value => value),
        writerVersion.map(value => value)
      )
    def blockSizeBytes: Optional[BlockSizeBytes]
    def pageSizeBytes: Optional[ParquetPageSizeBytes]
    def compression: Optional[zio.aws.firehose.model.ParquetCompression]
    def enableDictionaryCompression: Optional[BooleanObject]
    def maxPaddingBytes: Optional[NonNegativeIntegerObject]
    def writerVersion: Optional[zio.aws.firehose.model.ParquetWriterVersion]
    def getBlockSizeBytes: ZIO[Any, AwsError, BlockSizeBytes] =
      AwsError.unwrapOptionField("blockSizeBytes", blockSizeBytes)
    def getPageSizeBytes: ZIO[Any, AwsError, ParquetPageSizeBytes] =
      AwsError.unwrapOptionField("pageSizeBytes", pageSizeBytes)
    def getCompression
        : ZIO[Any, AwsError, zio.aws.firehose.model.ParquetCompression] =
      AwsError.unwrapOptionField("compression", compression)
    def getEnableDictionaryCompression: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField(
        "enableDictionaryCompression",
        enableDictionaryCompression
      )
    def getMaxPaddingBytes: ZIO[Any, AwsError, NonNegativeIntegerObject] =
      AwsError.unwrapOptionField("maxPaddingBytes", maxPaddingBytes)
    def getWriterVersion
        : ZIO[Any, AwsError, zio.aws.firehose.model.ParquetWriterVersion] =
      AwsError.unwrapOptionField("writerVersion", writerVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.ParquetSerDe
  ) extends zio.aws.firehose.model.ParquetSerDe.ReadOnly {
    override val blockSizeBytes: Optional[BlockSizeBytes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blockSizeBytes())
        .map(value => zio.aws.firehose.model.primitives.BlockSizeBytes(value))
    override val pageSizeBytes: Optional[ParquetPageSizeBytes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pageSizeBytes())
        .map(value =>
          zio.aws.firehose.model.primitives.ParquetPageSizeBytes(value)
        )
    override val compression
        : Optional[zio.aws.firehose.model.ParquetCompression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compression())
        .map(value => zio.aws.firehose.model.ParquetCompression.wrap(value))
    override val enableDictionaryCompression: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableDictionaryCompression())
        .map(value => value: BooleanObject)
    override val maxPaddingBytes: Optional[NonNegativeIntegerObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxPaddingBytes())
        .map(value =>
          zio.aws.firehose.model.primitives.NonNegativeIntegerObject(value)
        )
    override val writerVersion
        : Optional[zio.aws.firehose.model.ParquetWriterVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.writerVersion())
        .map(value => zio.aws.firehose.model.ParquetWriterVersion.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.ParquetSerDe
  ): zio.aws.firehose.model.ParquetSerDe.ReadOnly = new Wrapper(impl)
}
