package zio.aws.firehose.model
import scala.jdk.CollectionConverters.*
sealed trait ParquetWriterVersion {
  def unwrap
      : software.amazon.awssdk.services.firehose.model.ParquetWriterVersion
}
object ParquetWriterVersion {
  def wrap(
      value: software.amazon.awssdk.services.firehose.model.ParquetWriterVersion
  ): zio.aws.firehose.model.ParquetWriterVersion = value match {
    case software.amazon.awssdk.services.firehose.model.ParquetWriterVersion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.firehose.model.ParquetWriterVersion.V1 =>
      val r = V1
      r
    case software.amazon.awssdk.services.firehose.model.ParquetWriterVersion.V2 =>
      val r = V2
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.firehose.model.ParquetWriterVersion {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ParquetWriterVersion =
      software.amazon.awssdk.services.firehose.model.ParquetWriterVersion.UNKNOWN_TO_SDK_VERSION
  }
  case object V1 extends zio.aws.firehose.model.ParquetWriterVersion {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ParquetWriterVersion =
      software.amazon.awssdk.services.firehose.model.ParquetWriterVersion.V1
  }
  case object V2 extends zio.aws.firehose.model.ParquetWriterVersion {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ParquetWriterVersion =
      software.amazon.awssdk.services.firehose.model.ParquetWriterVersion.V2
  }
}
