package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.ProcessorParameterValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ProcessorParameter(
    parameterName: zio.aws.firehose.model.ProcessorParameterName,
    parameterValue: ProcessorParameterValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.ProcessorParameter = {
    import ProcessorParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.ProcessorParameter
      .builder()
      .parameterName(parameterName.unwrap)
      .parameterValue(
        ProcessorParameterValue.unwrap(parameterValue): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.ProcessorParameter.ReadOnly =
    zio.aws.firehose.model.ProcessorParameter.wrap(buildAwsValue())
}
object ProcessorParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.ProcessorParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.ProcessorParameter =
      zio.aws.firehose.model.ProcessorParameter(parameterName, parameterValue)
    def parameterName: zio.aws.firehose.model.ProcessorParameterName
    def parameterValue: ProcessorParameterValue
    def getParameterName
        : ZIO[Any, Nothing, zio.aws.firehose.model.ProcessorParameterName] =
      ZIO.succeed(parameterName)
    def getParameterValue: ZIO[Any, Nothing, ProcessorParameterValue] =
      ZIO.succeed(parameterValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.ProcessorParameter
  ) extends zio.aws.firehose.model.ProcessorParameter.ReadOnly {
    override val parameterName: zio.aws.firehose.model.ProcessorParameterName =
      zio.aws.firehose.model.ProcessorParameterName.wrap(impl.parameterName())
    override val parameterValue: ProcessorParameterValue =
      zio.aws.firehose.model.primitives
        .ProcessorParameterValue(impl.parameterValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.ProcessorParameter
  ): zio.aws.firehose.model.ProcessorParameter.ReadOnly = new Wrapper(impl)
}
