package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  ErrorMessage,
  ErrorCode,
  PutResponseRecordId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutRecordBatchResponseEntry(
    recordId: Optional[PutResponseRecordId] = Optional.Absent,
    errorCode: Optional[ErrorCode] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.PutRecordBatchResponseEntry = {
    import PutRecordBatchResponseEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.PutRecordBatchResponseEntry
      .builder()
      .optionallyWith(
        recordId.map(value =>
          PutResponseRecordId.unwrap(value): java.lang.String
        )
      )(_.recordId)
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.PutRecordBatchResponseEntry.ReadOnly =
    zio.aws.firehose.model.PutRecordBatchResponseEntry.wrap(buildAwsValue())
}
object PutRecordBatchResponseEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.PutRecordBatchResponseEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.PutRecordBatchResponseEntry =
      zio.aws.firehose.model.PutRecordBatchResponseEntry(
        recordId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def recordId: Optional[PutResponseRecordId]
    def errorCode: Optional[ErrorCode]
    def errorMessage: Optional[ErrorMessage]
    def getRecordId: ZIO[Any, AwsError, PutResponseRecordId] =
      AwsError.unwrapOptionField("recordId", recordId)
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.PutRecordBatchResponseEntry
  ) extends zio.aws.firehose.model.PutRecordBatchResponseEntry.ReadOnly {
    override val recordId: Optional[PutResponseRecordId] = zio.aws.core.internal
      .optionalFromNullable(impl.recordId())
      .map(value =>
        zio.aws.firehose.model.primitives.PutResponseRecordId(value)
      )
    override val errorCode: Optional[ErrorCode] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => zio.aws.firehose.model.primitives.ErrorCode(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.firehose.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.PutRecordBatchResponseEntry
  ): zio.aws.firehose.model.PutRecordBatchResponseEntry.ReadOnly = new Wrapper(
    impl
  )
}
