package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  Password,
  Username,
  ClusterJDBCURL,
  RoleARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RedshiftDestinationConfiguration(
    roleARN: RoleARN,
    clusterJDBCURL: ClusterJDBCURL,
    copyCommand: zio.aws.firehose.model.CopyCommand,
    username: Username,
    password: Password,
    retryOptions: Optional[zio.aws.firehose.model.RedshiftRetryOptions] =
      Optional.Absent,
    s3Configuration: zio.aws.firehose.model.S3DestinationConfiguration,
    processingConfiguration: Optional[
      zio.aws.firehose.model.ProcessingConfiguration
    ] = Optional.Absent,
    s3BackupMode: Optional[zio.aws.firehose.model.RedshiftS3BackupMode] =
      Optional.Absent,
    s3BackupConfiguration: Optional[
      zio.aws.firehose.model.S3DestinationConfiguration
    ] = Optional.Absent,
    cloudWatchLoggingOptions: Optional[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.RedshiftDestinationConfiguration = {
    import RedshiftDestinationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.RedshiftDestinationConfiguration
      .builder()
      .roleARN(RoleARN.unwrap(roleARN): java.lang.String)
      .clusterJDBCURL(ClusterJDBCURL.unwrap(clusterJDBCURL): java.lang.String)
      .copyCommand(copyCommand.buildAwsValue())
      .username(Username.unwrap(username): java.lang.String)
      .password(Password.unwrap(password): java.lang.String)
      .optionallyWith(retryOptions.map(value => value.buildAwsValue()))(
        _.retryOptions
      )
      .s3Configuration(s3Configuration.buildAwsValue())
      .optionallyWith(
        processingConfiguration.map(value => value.buildAwsValue())
      )(_.processingConfiguration)
      .optionallyWith(s3BackupMode.map(value => value.unwrap))(_.s3BackupMode)
      .optionallyWith(
        s3BackupConfiguration.map(value => value.buildAwsValue())
      )(_.s3BackupConfiguration)
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.RedshiftDestinationConfiguration.ReadOnly =
    zio.aws.firehose.model.RedshiftDestinationConfiguration
      .wrap(buildAwsValue())
}
object RedshiftDestinationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.RedshiftDestinationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.RedshiftDestinationConfiguration =
      zio.aws.firehose.model.RedshiftDestinationConfiguration(
        roleARN,
        clusterJDBCURL,
        copyCommand.asEditable,
        username,
        password,
        retryOptions.map(value => value.asEditable),
        s3Configuration.asEditable,
        processingConfiguration.map(value => value.asEditable),
        s3BackupMode.map(value => value),
        s3BackupConfiguration.map(value => value.asEditable),
        cloudWatchLoggingOptions.map(value => value.asEditable)
      )
    def roleARN: RoleARN
    def clusterJDBCURL: ClusterJDBCURL
    def copyCommand: zio.aws.firehose.model.CopyCommand.ReadOnly
    def username: Username
    def password: Password
    def retryOptions
        : Optional[zio.aws.firehose.model.RedshiftRetryOptions.ReadOnly]
    def s3Configuration
        : zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly
    def processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly]
    def s3BackupMode: Optional[zio.aws.firehose.model.RedshiftS3BackupMode]
    def s3BackupConfiguration
        : Optional[zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly]
    def cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def getRoleARN: ZIO[Any, Nothing, RoleARN] = ZIO.succeed(roleARN)
    def getClusterJDBCURL: ZIO[Any, Nothing, ClusterJDBCURL] =
      ZIO.succeed(clusterJDBCURL)
    def getCopyCommand
        : ZIO[Any, Nothing, zio.aws.firehose.model.CopyCommand.ReadOnly] =
      ZIO.succeed(copyCommand)
    def getUsername: ZIO[Any, Nothing, Username] = ZIO.succeed(username)
    def getPassword: ZIO[Any, Nothing, Password] = ZIO.succeed(password)
    def getRetryOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.RedshiftRetryOptions.ReadOnly
    ] = AwsError.unwrapOptionField("retryOptions", retryOptions)
    def getS3Configuration: ZIO[
      Any,
      Nothing,
      zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly
    ] = ZIO.succeed(s3Configuration)
    def getProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingConfiguration",
      processingConfiguration
    )
    def getS3BackupMode
        : ZIO[Any, AwsError, zio.aws.firehose.model.RedshiftS3BackupMode] =
      AwsError.unwrapOptionField("s3BackupMode", s3BackupMode)
    def getS3BackupConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("s3BackupConfiguration", s3BackupConfiguration)
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.RedshiftDestinationConfiguration
  ) extends zio.aws.firehose.model.RedshiftDestinationConfiguration.ReadOnly {
    override val roleARN: RoleARN =
      zio.aws.firehose.model.primitives.RoleARN(impl.roleARN())
    override val clusterJDBCURL: ClusterJDBCURL =
      zio.aws.firehose.model.primitives.ClusterJDBCURL(impl.clusterJDBCURL())
    override val copyCommand: zio.aws.firehose.model.CopyCommand.ReadOnly =
      zio.aws.firehose.model.CopyCommand.wrap(impl.copyCommand())
    override val username: Username =
      zio.aws.firehose.model.primitives.Username(impl.username())
    override val password: Password =
      zio.aws.firehose.model.primitives.Password(impl.password())
    override val retryOptions
        : Optional[zio.aws.firehose.model.RedshiftRetryOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retryOptions())
        .map(value => zio.aws.firehose.model.RedshiftRetryOptions.wrap(value))
    override val s3Configuration
        : zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly =
      zio.aws.firehose.model.S3DestinationConfiguration
        .wrap(impl.s3Configuration())
    override val processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processingConfiguration())
        .map(value =>
          zio.aws.firehose.model.ProcessingConfiguration.wrap(value)
        )
    override val s3BackupMode
        : Optional[zio.aws.firehose.model.RedshiftS3BackupMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3BackupMode())
        .map(value => zio.aws.firehose.model.RedshiftS3BackupMode.wrap(value))
    override val s3BackupConfiguration
        : Optional[zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3BackupConfiguration())
        .map(value =>
          zio.aws.firehose.model.S3DestinationConfiguration.wrap(value)
        )
    override val cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.RedshiftDestinationConfiguration
  ): zio.aws.firehose.model.RedshiftDestinationConfiguration.ReadOnly =
    new Wrapper(impl)
}
