package zio.aws.firehose.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.firehose.model.primitives.RedshiftRetryDurationInSeconds
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class RedshiftRetryOptions(
    durationInSeconds: Optional[RedshiftRetryDurationInSeconds] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.RedshiftRetryOptions = {
    import RedshiftRetryOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.RedshiftRetryOptions
      .builder()
      .optionallyWith(
        durationInSeconds.map(value =>
          RedshiftRetryDurationInSeconds.unwrap(value): Integer
        )
      )(_.durationInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.RedshiftRetryOptions.ReadOnly =
    zio.aws.firehose.model.RedshiftRetryOptions.wrap(buildAwsValue())
}
object RedshiftRetryOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.RedshiftRetryOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.RedshiftRetryOptions =
      zio.aws.firehose.model
        .RedshiftRetryOptions(durationInSeconds.map(value => value))
    def durationInSeconds: Optional[RedshiftRetryDurationInSeconds]
    def getDurationInSeconds
        : ZIO[Any, AwsError, RedshiftRetryDurationInSeconds] =
      AwsError.unwrapOptionField("durationInSeconds", durationInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.RedshiftRetryOptions
  ) extends zio.aws.firehose.model.RedshiftRetryOptions.ReadOnly {
    override val durationInSeconds: Optional[RedshiftRetryDurationInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationInSeconds())
        .map(value =>
          zio.aws.firehose.model.primitives
            .RedshiftRetryDurationInSeconds(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.RedshiftRetryOptions
  ): zio.aws.firehose.model.RedshiftRetryOptions.ReadOnly = new Wrapper(impl)
}
