package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.NonEmptyStringWithoutWhitespace
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SchemaConfiguration(
    roleARN: Optional[NonEmptyStringWithoutWhitespace] = Optional.Absent,
    catalogId: Optional[NonEmptyStringWithoutWhitespace] = Optional.Absent,
    databaseName: Optional[NonEmptyStringWithoutWhitespace] = Optional.Absent,
    tableName: Optional[NonEmptyStringWithoutWhitespace] = Optional.Absent,
    region: Optional[NonEmptyStringWithoutWhitespace] = Optional.Absent,
    versionId: Optional[NonEmptyStringWithoutWhitespace] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.SchemaConfiguration = {
    import SchemaConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.SchemaConfiguration
      .builder()
      .optionallyWith(
        roleARN.map(value =>
          NonEmptyStringWithoutWhitespace.unwrap(value): java.lang.String
        )
      )(_.roleARN)
      .optionallyWith(
        catalogId.map(value =>
          NonEmptyStringWithoutWhitespace.unwrap(value): java.lang.String
        )
      )(_.catalogId)
      .optionallyWith(
        databaseName.map(value =>
          NonEmptyStringWithoutWhitespace.unwrap(value): java.lang.String
        )
      )(_.databaseName)
      .optionallyWith(
        tableName.map(value =>
          NonEmptyStringWithoutWhitespace.unwrap(value): java.lang.String
        )
      )(_.tableName)
      .optionallyWith(
        region.map(value =>
          NonEmptyStringWithoutWhitespace.unwrap(value): java.lang.String
        )
      )(_.region)
      .optionallyWith(
        versionId.map(value =>
          NonEmptyStringWithoutWhitespace.unwrap(value): java.lang.String
        )
      )(_.versionId)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.SchemaConfiguration.ReadOnly =
    zio.aws.firehose.model.SchemaConfiguration.wrap(buildAwsValue())
}
object SchemaConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.SchemaConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.SchemaConfiguration =
      zio.aws.firehose.model.SchemaConfiguration(
        roleARN.map(value => value),
        catalogId.map(value => value),
        databaseName.map(value => value),
        tableName.map(value => value),
        region.map(value => value),
        versionId.map(value => value)
      )
    def roleARN: Optional[NonEmptyStringWithoutWhitespace]
    def catalogId: Optional[NonEmptyStringWithoutWhitespace]
    def databaseName: Optional[NonEmptyStringWithoutWhitespace]
    def tableName: Optional[NonEmptyStringWithoutWhitespace]
    def region: Optional[NonEmptyStringWithoutWhitespace]
    def versionId: Optional[NonEmptyStringWithoutWhitespace]
    def getRoleARN: ZIO[Any, AwsError, NonEmptyStringWithoutWhitespace] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getCatalogId: ZIO[Any, AwsError, NonEmptyStringWithoutWhitespace] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getDatabaseName: ZIO[Any, AwsError, NonEmptyStringWithoutWhitespace] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getTableName: ZIO[Any, AwsError, NonEmptyStringWithoutWhitespace] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getRegion: ZIO[Any, AwsError, NonEmptyStringWithoutWhitespace] =
      AwsError.unwrapOptionField("region", region)
    def getVersionId: ZIO[Any, AwsError, NonEmptyStringWithoutWhitespace] =
      AwsError.unwrapOptionField("versionId", versionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.SchemaConfiguration
  ) extends zio.aws.firehose.model.SchemaConfiguration.ReadOnly {
    override val roleARN: Optional[NonEmptyStringWithoutWhitespace] =
      zio.aws.core.internal
        .optionalFromNullable(impl.roleARN())
        .map(value =>
          zio.aws.firehose.model.primitives
            .NonEmptyStringWithoutWhitespace(value)
        )
    override val catalogId: Optional[NonEmptyStringWithoutWhitespace] =
      zio.aws.core.internal
        .optionalFromNullable(impl.catalogId())
        .map(value =>
          zio.aws.firehose.model.primitives
            .NonEmptyStringWithoutWhitespace(value)
        )
    override val databaseName: Optional[NonEmptyStringWithoutWhitespace] =
      zio.aws.core.internal
        .optionalFromNullable(impl.databaseName())
        .map(value =>
          zio.aws.firehose.model.primitives
            .NonEmptyStringWithoutWhitespace(value)
        )
    override val tableName: Optional[NonEmptyStringWithoutWhitespace] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tableName())
        .map(value =>
          zio.aws.firehose.model.primitives
            .NonEmptyStringWithoutWhitespace(value)
        )
    override val region: Optional[NonEmptyStringWithoutWhitespace] =
      zio.aws.core.internal
        .optionalFromNullable(impl.region())
        .map(value =>
          zio.aws.firehose.model.primitives
            .NonEmptyStringWithoutWhitespace(value)
        )
    override val versionId: Optional[NonEmptyStringWithoutWhitespace] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionId())
        .map(value =>
          zio.aws.firehose.model.primitives
            .NonEmptyStringWithoutWhitespace(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.SchemaConfiguration
  ): zio.aws.firehose.model.SchemaConfiguration.ReadOnly = new Wrapper(impl)
}
