package zio.aws.firehose.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.firehose.model.primitives.{
  HECAcknowledgmentTimeoutInSeconds,
  HECToken,
  HECEndpoint
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SplunkDestinationConfiguration(
    hecEndpoint: HECEndpoint,
    hecEndpointType: zio.aws.firehose.model.HECEndpointType,
    hecToken: HECToken,
    hecAcknowledgmentTimeoutInSeconds: Optional[
      HECAcknowledgmentTimeoutInSeconds
    ] = Optional.Absent,
    retryOptions: Optional[zio.aws.firehose.model.SplunkRetryOptions] =
      Optional.Absent,
    s3BackupMode: Optional[zio.aws.firehose.model.SplunkS3BackupMode] =
      Optional.Absent,
    s3Configuration: zio.aws.firehose.model.S3DestinationConfiguration,
    processingConfiguration: Optional[
      zio.aws.firehose.model.ProcessingConfiguration
    ] = Optional.Absent,
    cloudWatchLoggingOptions: Optional[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.SplunkDestinationConfiguration = {
    import SplunkDestinationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.SplunkDestinationConfiguration
      .builder()
      .hecEndpoint(HECEndpoint.unwrap(hecEndpoint): java.lang.String)
      .hecEndpointType(hecEndpointType.unwrap)
      .hecToken(HECToken.unwrap(hecToken): java.lang.String)
      .optionallyWith(
        hecAcknowledgmentTimeoutInSeconds.map(value =>
          HECAcknowledgmentTimeoutInSeconds.unwrap(value): Integer
        )
      )(_.hecAcknowledgmentTimeoutInSeconds)
      .optionallyWith(retryOptions.map(value => value.buildAwsValue()))(
        _.retryOptions
      )
      .optionallyWith(s3BackupMode.map(value => value.unwrap))(_.s3BackupMode)
      .s3Configuration(s3Configuration.buildAwsValue())
      .optionallyWith(
        processingConfiguration.map(value => value.buildAwsValue())
      )(_.processingConfiguration)
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.SplunkDestinationConfiguration.ReadOnly =
    zio.aws.firehose.model.SplunkDestinationConfiguration.wrap(buildAwsValue())
}
object SplunkDestinationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.SplunkDestinationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.SplunkDestinationConfiguration =
      zio.aws.firehose.model.SplunkDestinationConfiguration(
        hecEndpoint,
        hecEndpointType,
        hecToken,
        hecAcknowledgmentTimeoutInSeconds.map(value => value),
        retryOptions.map(value => value.asEditable),
        s3BackupMode.map(value => value),
        s3Configuration.asEditable,
        processingConfiguration.map(value => value.asEditable),
        cloudWatchLoggingOptions.map(value => value.asEditable)
      )
    def hecEndpoint: HECEndpoint
    def hecEndpointType: zio.aws.firehose.model.HECEndpointType
    def hecToken: HECToken
    def hecAcknowledgmentTimeoutInSeconds
        : Optional[HECAcknowledgmentTimeoutInSeconds]
    def retryOptions
        : Optional[zio.aws.firehose.model.SplunkRetryOptions.ReadOnly]
    def s3BackupMode: Optional[zio.aws.firehose.model.SplunkS3BackupMode]
    def s3Configuration
        : zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly
    def processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly]
    def cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def getHecEndpoint: ZIO[Any, Nothing, HECEndpoint] =
      ZIO.succeed(hecEndpoint)
    def getHecEndpointType
        : ZIO[Any, Nothing, zio.aws.firehose.model.HECEndpointType] =
      ZIO.succeed(hecEndpointType)
    def getHecToken: ZIO[Any, Nothing, HECToken] = ZIO.succeed(hecToken)
    def getHecAcknowledgmentTimeoutInSeconds
        : ZIO[Any, AwsError, HECAcknowledgmentTimeoutInSeconds] =
      AwsError.unwrapOptionField(
        "hecAcknowledgmentTimeoutInSeconds",
        hecAcknowledgmentTimeoutInSeconds
      )
    def getRetryOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.SplunkRetryOptions.ReadOnly
    ] = AwsError.unwrapOptionField("retryOptions", retryOptions)
    def getS3BackupMode
        : ZIO[Any, AwsError, zio.aws.firehose.model.SplunkS3BackupMode] =
      AwsError.unwrapOptionField("s3BackupMode", s3BackupMode)
    def getS3Configuration: ZIO[
      Any,
      Nothing,
      zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly
    ] = ZIO.succeed(s3Configuration)
    def getProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingConfiguration",
      processingConfiguration
    )
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.SplunkDestinationConfiguration
  ) extends zio.aws.firehose.model.SplunkDestinationConfiguration.ReadOnly {
    override val hecEndpoint: HECEndpoint =
      zio.aws.firehose.model.primitives.HECEndpoint(impl.hecEndpoint())
    override val hecEndpointType: zio.aws.firehose.model.HECEndpointType =
      zio.aws.firehose.model.HECEndpointType.wrap(impl.hecEndpointType())
    override val hecToken: HECToken =
      zio.aws.firehose.model.primitives.HECToken(impl.hecToken())
    override val hecAcknowledgmentTimeoutInSeconds
        : Optional[HECAcknowledgmentTimeoutInSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.hecAcknowledgmentTimeoutInSeconds())
      .map(value =>
        zio.aws.firehose.model.primitives
          .HECAcknowledgmentTimeoutInSeconds(value)
      )
    override val retryOptions
        : Optional[zio.aws.firehose.model.SplunkRetryOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retryOptions())
        .map(value => zio.aws.firehose.model.SplunkRetryOptions.wrap(value))
    override val s3BackupMode
        : Optional[zio.aws.firehose.model.SplunkS3BackupMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3BackupMode())
        .map(value => zio.aws.firehose.model.SplunkS3BackupMode.wrap(value))
    override val s3Configuration
        : zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly =
      zio.aws.firehose.model.S3DestinationConfiguration
        .wrap(impl.s3Configuration())
    override val processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processingConfiguration())
        .map(value =>
          zio.aws.firehose.model.ProcessingConfiguration.wrap(value)
        )
    override val cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.SplunkDestinationConfiguration
  ): zio.aws.firehose.model.SplunkDestinationConfiguration.ReadOnly =
    new Wrapper(impl)
}
