package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Tag(key: TagKey, value: Optional[TagValue] = Optional.Absent) {
  def buildAwsValue(): software.amazon.awssdk.services.firehose.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.Tag
      .builder()
      .key(TagKey.unwrap(key): java.lang.String)
      .optionallyWith(
        value.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.Tag.ReadOnly =
    zio.aws.firehose.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.firehose.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.Tag =
      zio.aws.firehose.model.Tag(key, value.map(value => value))
    def key: TagKey
    def value: Optional[TagValue]
    def getKey: ZIO[Any, Nothing, TagKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.Tag
  ) extends zio.aws.firehose.model.Tag.ReadOnly {
    override val key: TagKey =
      zio.aws.firehose.model.primitives.TagKey(impl.key())
    override val value: Optional[TagValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.firehose.model.primitives.TagValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.Tag
  ): zio.aws.firehose.model.Tag.ReadOnly = new Wrapper(impl)
}
