package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  RoleARN,
  NonEmptyStringWithoutWhitespace
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class VpcConfiguration(
    subnetIds: Iterable[NonEmptyStringWithoutWhitespace],
    roleARN: RoleARN,
    securityGroupIds: Iterable[NonEmptyStringWithoutWhitespace]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.VpcConfiguration = {
    import VpcConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.VpcConfiguration
      .builder()
      .subnetIds(subnetIds.map { item =>
        NonEmptyStringWithoutWhitespace.unwrap(item): java.lang.String
      }.asJavaCollection)
      .roleARN(RoleARN.unwrap(roleARN): java.lang.String)
      .securityGroupIds(securityGroupIds.map { item =>
        NonEmptyStringWithoutWhitespace.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.VpcConfiguration.ReadOnly =
    zio.aws.firehose.model.VpcConfiguration.wrap(buildAwsValue())
}
object VpcConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.VpcConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.VpcConfiguration =
      zio.aws.firehose.model
        .VpcConfiguration(subnetIds, roleARN, securityGroupIds)
    def subnetIds: List[NonEmptyStringWithoutWhitespace]
    def roleARN: RoleARN
    def securityGroupIds: List[NonEmptyStringWithoutWhitespace]
    def getSubnetIds: ZIO[Any, Nothing, List[NonEmptyStringWithoutWhitespace]] =
      ZIO.succeed(subnetIds)
    def getRoleARN: ZIO[Any, Nothing, RoleARN] = ZIO.succeed(roleARN)
    def getSecurityGroupIds
        : ZIO[Any, Nothing, List[NonEmptyStringWithoutWhitespace]] =
      ZIO.succeed(securityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.VpcConfiguration
  ) extends zio.aws.firehose.model.VpcConfiguration.ReadOnly {
    override val subnetIds: List[NonEmptyStringWithoutWhitespace] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.firehose.model.primitives.NonEmptyStringWithoutWhitespace(item)
      }
      .toList
    override val roleARN: RoleARN =
      zio.aws.firehose.model.primitives.RoleARN(impl.roleARN())
    override val securityGroupIds: List[NonEmptyStringWithoutWhitespace] = impl
      .securityGroupIds()
      .asScala
      .map { item =>
        zio.aws.firehose.model.primitives.NonEmptyStringWithoutWhitespace(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.VpcConfiguration
  ): zio.aws.firehose.model.VpcConfiguration.ReadOnly = new Wrapper(impl)
}
