package zio.aws.fms
import zio.aws.fms.model.GetProtocolsListResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.fms.FmsAsyncClient
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.fms.model.primitives.{ProtectionData, AWSAccountId}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.aws.fms.model.{
  GetComplianceDetailRequest,
  GetViolationDetailsRequest,
  ListProtocolsListsRequest,
  PutNotificationChannelRequest,
  ListPoliciesRequest,
  DisassociateAdminAccountRequest,
  GetThirdPartyFirewallAssociationStatusRequest,
  PutAppsListRequest,
  AssociateAdminAccountRequest,
  GetProtocolsListRequest,
  ListTagsForResourceRequest,
  DisassociateThirdPartyFirewallRequest,
  GetNotificationChannelRequest,
  ListComplianceStatusRequest,
  GetProtectionStatusRequest,
  ListThirdPartyFirewallFirewallPoliciesRequest,
  GetAppsListRequest,
  PutProtocolsListRequest,
  GetAdminAccountRequest,
  DeleteAppsListRequest,
  AssociateThirdPartyFirewallRequest,
  GetPolicyRequest,
  UntagResourceRequest,
  ListAppsListsRequest,
  ListMemberAccountsRequest,
  DeleteNotificationChannelRequest,
  DeletePolicyRequest,
  DeleteProtocolsListRequest,
  PutPolicyRequest,
  TagResourceRequest
}
object FmsMock extends Mock[Fms] {
  object ListMemberAccounts
      extends Stream[ListMemberAccountsRequest, AwsError, AWSAccountId]
  object ListMemberAccountsPaginated
      extends Effect[
        ListMemberAccountsRequest,
        AwsError,
        zio.aws.fms.model.ListMemberAccountsResponse.ReadOnly
      ]
  object GetThirdPartyFirewallAssociationStatus
      extends Effect[
        GetThirdPartyFirewallAssociationStatusRequest,
        AwsError,
        zio.aws.fms.model.GetThirdPartyFirewallAssociationStatusResponse.ReadOnly
      ]
  object GetNotificationChannel
      extends Effect[
        GetNotificationChannelRequest,
        AwsError,
        zio.aws.fms.model.GetNotificationChannelResponse.ReadOnly
      ]
  object GetProtectionStatus
      extends Effect[
        GetProtectionStatusRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.fms.model.GetProtectionStatusResponse.ReadOnly,
          ProtectionData
        ]
      ]
  object GetProtectionStatusPaginated
      extends Effect[
        GetProtectionStatusRequest,
        AwsError,
        zio.aws.fms.model.GetProtectionStatusResponse.ReadOnly
      ]
  object DeleteProtocolsList
      extends Effect[DeleteProtocolsListRequest, AwsError, Unit]
  object DisassociateAdminAccount
      extends Effect[DisassociateAdminAccountRequest, AwsError, Unit]
  object GetAdminAccount
      extends Effect[
        GetAdminAccountRequest,
        AwsError,
        zio.aws.fms.model.GetAdminAccountResponse.ReadOnly
      ]
  object GetProtocolsList
      extends Effect[GetProtocolsListRequest, AwsError, ReadOnly]
  object PutPolicy
      extends Effect[
        PutPolicyRequest,
        AwsError,
        zio.aws.fms.model.PutPolicyResponse.ReadOnly
      ]
  object PutProtocolsList
      extends Effect[
        PutProtocolsListRequest,
        AwsError,
        zio.aws.fms.model.PutProtocolsListResponse.ReadOnly
      ]
  object ListPolicies
      extends Stream[
        ListPoliciesRequest,
        AwsError,
        zio.aws.fms.model.PolicySummary.ReadOnly
      ]
  object ListPoliciesPaginated
      extends Effect[
        ListPoliciesRequest,
        AwsError,
        zio.aws.fms.model.ListPoliciesResponse.ReadOnly
      ]
  object GetViolationDetails
      extends Effect[
        GetViolationDetailsRequest,
        AwsError,
        zio.aws.fms.model.GetViolationDetailsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.fms.model.UntagResourceResponse.ReadOnly
      ]
  object AssociateThirdPartyFirewall
      extends Effect[
        AssociateThirdPartyFirewallRequest,
        AwsError,
        zio.aws.fms.model.AssociateThirdPartyFirewallResponse.ReadOnly
      ]
  object ListComplianceStatus
      extends Stream[
        ListComplianceStatusRequest,
        AwsError,
        zio.aws.fms.model.PolicyComplianceStatus.ReadOnly
      ]
  object ListComplianceStatusPaginated
      extends Effect[
        ListComplianceStatusRequest,
        AwsError,
        zio.aws.fms.model.ListComplianceStatusResponse.ReadOnly
      ]
  object DeleteAppsList extends Effect[DeleteAppsListRequest, AwsError, Unit]
  object DeleteNotificationChannel
      extends Effect[DeleteNotificationChannelRequest, AwsError, Unit]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.fms.model.ListTagsForResourceResponse.ReadOnly
      ]
  object GetAppsList
      extends Effect[
        GetAppsListRequest,
        AwsError,
        zio.aws.fms.model.GetAppsListResponse.ReadOnly
      ]
  object ListThirdPartyFirewallFirewallPolicies
      extends Stream[
        ListThirdPartyFirewallFirewallPoliciesRequest,
        AwsError,
        zio.aws.fms.model.ThirdPartyFirewallFirewallPolicy.ReadOnly
      ]
  object ListThirdPartyFirewallFirewallPoliciesPaginated
      extends Effect[
        ListThirdPartyFirewallFirewallPoliciesRequest,
        AwsError,
        zio.aws.fms.model.ListThirdPartyFirewallFirewallPoliciesResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.fms.model.TagResourceResponse.ReadOnly
      ]
  object DeletePolicy extends Effect[DeletePolicyRequest, AwsError, Unit]
  object GetPolicy
      extends Effect[
        GetPolicyRequest,
        AwsError,
        zio.aws.fms.model.GetPolicyResponse.ReadOnly
      ]
  object AssociateAdminAccount
      extends Effect[AssociateAdminAccountRequest, AwsError, Unit]
  object DisassociateThirdPartyFirewall
      extends Effect[
        DisassociateThirdPartyFirewallRequest,
        AwsError,
        zio.aws.fms.model.DisassociateThirdPartyFirewallResponse.ReadOnly
      ]
  object PutAppsList
      extends Effect[
        PutAppsListRequest,
        AwsError,
        zio.aws.fms.model.PutAppsListResponse.ReadOnly
      ]
  object ListAppsLists
      extends Stream[
        ListAppsListsRequest,
        AwsError,
        zio.aws.fms.model.AppsListDataSummary.ReadOnly
      ]
  object ListAppsListsPaginated
      extends Effect[
        ListAppsListsRequest,
        AwsError,
        zio.aws.fms.model.ListAppsListsResponse.ReadOnly
      ]
  object PutNotificationChannel
      extends Effect[PutNotificationChannelRequest, AwsError, Unit]
  object ListProtocolsLists
      extends Stream[
        ListProtocolsListsRequest,
        AwsError,
        zio.aws.fms.model.ProtocolsListDataSummary.ReadOnly
      ]
  object ListProtocolsListsPaginated
      extends Effect[
        ListProtocolsListsRequest,
        AwsError,
        zio.aws.fms.model.ListProtocolsListsResponse.ReadOnly
      ]
  object GetComplianceDetail
      extends Effect[
        GetComplianceDetailRequest,
        AwsError,
        zio.aws.fms.model.GetComplianceDetailResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Fms] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Fms] { rts =>
        zio.ZIO.succeed {
          new Fms {
            val api: FmsAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Fms = this
            def listMemberAccounts(
                request: ListMemberAccountsRequest
            ): ZStream[Any, AwsError, AWSAccountId] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListMemberAccounts, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listMemberAccountsPaginated(
                request: ListMemberAccountsRequest
            ): IO[
              AwsError,
              zio.aws.fms.model.ListMemberAccountsResponse.ReadOnly
            ] = proxy(ListMemberAccountsPaginated, request)
            def getThirdPartyFirewallAssociationStatus(
                request: GetThirdPartyFirewallAssociationStatusRequest
            ): IO[
              AwsError,
              zio.aws.fms.model.GetThirdPartyFirewallAssociationStatusResponse.ReadOnly
            ] = proxy(GetThirdPartyFirewallAssociationStatus, request)
            def getNotificationChannel(
                request: GetNotificationChannelRequest
            ): IO[
              AwsError,
              zio.aws.fms.model.GetNotificationChannelResponse.ReadOnly
            ] = proxy(GetNotificationChannel, request)
            def getProtectionStatus(
                request: GetProtectionStatusRequest
            ): IO[AwsError, StreamingOutputResult[
              Any,
              zio.aws.fms.model.GetProtectionStatusResponse.ReadOnly,
              ProtectionData
            ]] = proxy(GetProtectionStatus, request)
            def getProtectionStatusPaginated(
                request: GetProtectionStatusRequest
            ): IO[
              AwsError,
              zio.aws.fms.model.GetProtectionStatusResponse.ReadOnly
            ] = proxy(GetProtectionStatusPaginated, request)
            def deleteProtocolsList(
                request: DeleteProtocolsListRequest
            ): IO[AwsError, Unit] = proxy(DeleteProtocolsList, request)
            def disassociateAdminAccount(
                request: DisassociateAdminAccountRequest
            ): IO[AwsError, Unit] = proxy(DisassociateAdminAccount, request)
            def getAdminAccount(request: GetAdminAccountRequest): IO[
              AwsError,
              zio.aws.fms.model.GetAdminAccountResponse.ReadOnly
            ] = proxy(GetAdminAccount, request)
            def getProtocolsList(
                request: GetProtocolsListRequest
            ): IO[AwsError, ReadOnly] = proxy(GetProtocolsList, request)
            def putPolicy(
                request: PutPolicyRequest
            ): IO[AwsError, zio.aws.fms.model.PutPolicyResponse.ReadOnly] =
              proxy(PutPolicy, request)
            def putProtocolsList(request: PutProtocolsListRequest): IO[
              AwsError,
              zio.aws.fms.model.PutProtocolsListResponse.ReadOnly
            ] = proxy(PutProtocolsList, request)
            def listPolicies(request: ListPoliciesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.fms.model.PolicySummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPolicies, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPoliciesPaginated(
                request: ListPoliciesRequest
            ): IO[AwsError, zio.aws.fms.model.ListPoliciesResponse.ReadOnly] =
              proxy(ListPoliciesPaginated, request)
            def getViolationDetails(request: GetViolationDetailsRequest): IO[
              AwsError,
              zio.aws.fms.model.GetViolationDetailsResponse.ReadOnly
            ] = proxy(GetViolationDetails, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, zio.aws.fms.model.UntagResourceResponse.ReadOnly] =
              proxy(UntagResource, request)
            def associateThirdPartyFirewall(
                request: AssociateThirdPartyFirewallRequest
            ): IO[
              AwsError,
              zio.aws.fms.model.AssociateThirdPartyFirewallResponse.ReadOnly
            ] = proxy(AssociateThirdPartyFirewall, request)
            def listComplianceStatus(
                request: ListComplianceStatusRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.fms.model.PolicyComplianceStatus.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListComplianceStatus, request)
                }
                .getOrThrowFiberFailure()
            }
            def listComplianceStatusPaginated(
                request: ListComplianceStatusRequest
            ): IO[
              AwsError,
              zio.aws.fms.model.ListComplianceStatusResponse.ReadOnly
            ] = proxy(ListComplianceStatusPaginated, request)
            def deleteAppsList(
                request: DeleteAppsListRequest
            ): IO[AwsError, Unit] = proxy(DeleteAppsList, request)
            def deleteNotificationChannel(
                request: DeleteNotificationChannelRequest
            ): IO[AwsError, Unit] = proxy(DeleteNotificationChannel, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.fms.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def getAppsList(
                request: GetAppsListRequest
            ): IO[AwsError, zio.aws.fms.model.GetAppsListResponse.ReadOnly] =
              proxy(GetAppsList, request)
            def listThirdPartyFirewallFirewallPolicies(
                request: ListThirdPartyFirewallFirewallPoliciesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.fms.model.ThirdPartyFirewallFirewallPolicy.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListThirdPartyFirewallFirewallPolicies, request)
                }
                .getOrThrowFiberFailure()
            }
            def listThirdPartyFirewallFirewallPoliciesPaginated(
                request: ListThirdPartyFirewallFirewallPoliciesRequest
            ): IO[
              AwsError,
              zio.aws.fms.model.ListThirdPartyFirewallFirewallPoliciesResponse.ReadOnly
            ] = proxy(ListThirdPartyFirewallFirewallPoliciesPaginated, request)
            def tagResource(
                request: TagResourceRequest
            ): IO[AwsError, zio.aws.fms.model.TagResourceResponse.ReadOnly] =
              proxy(TagResource, request)
            def deletePolicy(request: DeletePolicyRequest): IO[AwsError, Unit] =
              proxy(DeletePolicy, request)
            def getPolicy(
                request: GetPolicyRequest
            ): IO[AwsError, zio.aws.fms.model.GetPolicyResponse.ReadOnly] =
              proxy(GetPolicy, request)
            def associateAdminAccount(
                request: AssociateAdminAccountRequest
            ): IO[AwsError, Unit] = proxy(AssociateAdminAccount, request)
            def disassociateThirdPartyFirewall(
                request: DisassociateThirdPartyFirewallRequest
            ): IO[
              AwsError,
              zio.aws.fms.model.DisassociateThirdPartyFirewallResponse.ReadOnly
            ] = proxy(DisassociateThirdPartyFirewall, request)
            def putAppsList(
                request: PutAppsListRequest
            ): IO[AwsError, zio.aws.fms.model.PutAppsListResponse.ReadOnly] =
              proxy(PutAppsList, request)
            def listAppsLists(request: ListAppsListsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.fms.model.AppsListDataSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAppsLists, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAppsListsPaginated(
                request: ListAppsListsRequest
            ): IO[AwsError, zio.aws.fms.model.ListAppsListsResponse.ReadOnly] =
              proxy(ListAppsListsPaginated, request)
            def putNotificationChannel(
                request: PutNotificationChannelRequest
            ): IO[AwsError, Unit] = proxy(PutNotificationChannel, request)
            def listProtocolsLists(request: ListProtocolsListsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.fms.model.ProtocolsListDataSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListProtocolsLists, request)
                }
                .getOrThrowFiberFailure()
            }
            def listProtocolsListsPaginated(
                request: ListProtocolsListsRequest
            ): IO[
              AwsError,
              zio.aws.fms.model.ListProtocolsListsResponse.ReadOnly
            ] = proxy(ListProtocolsListsPaginated, request)
            def getComplianceDetail(request: GetComplianceDetailRequest): IO[
              AwsError,
              zio.aws.fms.model.GetComplianceDetailResponse.ReadOnly
            ] = proxy(GetComplianceDetail, request)
          }
        }
      }
    }
  }
}
