package zio.aws.fms.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fms.model.primitives.{
  PreviousListVersion,
  UpdateToken,
  TimeStamp,
  ListId,
  ResourceName
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class AppsListData(
    listId: Optional[ListId] = Optional.Absent,
    listName: ResourceName,
    listUpdateToken: Optional[UpdateToken] = Optional.Absent,
    createTime: Optional[TimeStamp] = Optional.Absent,
    lastUpdateTime: Optional[TimeStamp] = Optional.Absent,
    appsList: Iterable[zio.aws.fms.model.App],
    previousAppsList: Optional[
      Map[PreviousListVersion, Iterable[zio.aws.fms.model.App]]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.AppsListData = {
    import AppsListData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.AppsListData
      .builder()
      .optionallyWith(
        listId.map(value => ListId.unwrap(value): java.lang.String)
      )(_.listId)
      .listName(ResourceName.unwrap(listName): java.lang.String)
      .optionallyWith(
        listUpdateToken.map(value =>
          UpdateToken.unwrap(value): java.lang.String
        )
      )(_.listUpdateToken)
      .optionallyWith(
        createTime.map(value => TimeStamp.unwrap(value): Instant)
      )(_.createTime)
      .optionallyWith(
        lastUpdateTime.map(value => TimeStamp.unwrap(value): Instant)
      )(_.lastUpdateTime)
      .appsList(appsList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        previousAppsList.map(value =>
          value
            .map({ case (key, value) =>
              (PreviousListVersion.unwrap(key): java.lang.String) -> value.map {
                item =>
                  item.buildAwsValue()
              }.asJavaCollection
            })
            .asJava
        )
      )(_.previousAppsList)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.AppsListData.ReadOnly =
    zio.aws.fms.model.AppsListData.wrap(buildAwsValue())
}
object AppsListData {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fms.model.AppsListData] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.AppsListData =
      zio.aws.fms.model.AppsListData(
        listId.map(value => value),
        listName,
        listUpdateToken.map(value => value),
        createTime.map(value => value),
        lastUpdateTime.map(value => value),
        appsList.map { item =>
          item.asEditable
        },
        previousAppsList.map(value =>
          value.map({ case (key, value) =>
            key -> value.map { item =>
              item.asEditable
            }
          })
        )
      )
    def listId: Optional[ListId]
    def listName: ResourceName
    def listUpdateToken: Optional[UpdateToken]
    def createTime: Optional[TimeStamp]
    def lastUpdateTime: Optional[TimeStamp]
    def appsList: List[zio.aws.fms.model.App.ReadOnly]
    def previousAppsList: Optional[
      Map[PreviousListVersion, List[zio.aws.fms.model.App.ReadOnly]]
    ]
    def getListId: ZIO[Any, AwsError, ListId] =
      AwsError.unwrapOptionField("listId", listId)
    def getListName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(listName)
    def getListUpdateToken: ZIO[Any, AwsError, UpdateToken] =
      AwsError.unwrapOptionField("listUpdateToken", listUpdateToken)
    def getCreateTime: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getLastUpdateTime: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
    def getAppsList: ZIO[Any, Nothing, List[zio.aws.fms.model.App.ReadOnly]] =
      ZIO.succeed(appsList)
    def getPreviousAppsList: ZIO[Any, AwsError, Map[PreviousListVersion, List[
      zio.aws.fms.model.App.ReadOnly
    ]]] = AwsError.unwrapOptionField("previousAppsList", previousAppsList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.AppsListData
  ) extends zio.aws.fms.model.AppsListData.ReadOnly {
    override val listId: Optional[ListId] = zio.aws.core.internal
      .optionalFromNullable(impl.listId())
      .map(value => zio.aws.fms.model.primitives.ListId(value))
    override val listName: ResourceName =
      zio.aws.fms.model.primitives.ResourceName(impl.listName())
    override val listUpdateToken: Optional[UpdateToken] = zio.aws.core.internal
      .optionalFromNullable(impl.listUpdateToken())
      .map(value => zio.aws.fms.model.primitives.UpdateToken(value))
    override val createTime: Optional[TimeStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.fms.model.primitives.TimeStamp(value))
    override val lastUpdateTime: Optional[TimeStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdateTime())
      .map(value => zio.aws.fms.model.primitives.TimeStamp(value))
    override val appsList: List[zio.aws.fms.model.App.ReadOnly] = impl
      .appsList()
      .asScala
      .map { item =>
        zio.aws.fms.model.App.wrap(item)
      }
      .toList
    override val previousAppsList: Optional[
      Map[PreviousListVersion, List[zio.aws.fms.model.App.ReadOnly]]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.previousAppsList())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.fms.model.primitives
              .PreviousListVersion(key) -> value.asScala.map { item =>
              zio.aws.fms.model.App.wrap(item)
            }.toList
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.AppsListData
  ): zio.aws.fms.model.AppsListData.ReadOnly = new Wrapper(impl)
}
