package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{ResourceName, ListId, ResourceArn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AppsListDataSummary(
    listArn: Optional[ResourceArn] = Optional.Absent,
    listId: Optional[ListId] = Optional.Absent,
    listName: Optional[ResourceName] = Optional.Absent,
    appsList: Optional[Iterable[zio.aws.fms.model.App]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.AppsListDataSummary = {
    import AppsListDataSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.AppsListDataSummary
      .builder()
      .optionallyWith(
        listArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.listArn)
      .optionallyWith(
        listId.map(value => ListId.unwrap(value): java.lang.String)
      )(_.listId)
      .optionallyWith(
        listName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.listName)
      .optionallyWith(
        appsList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.appsList)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.AppsListDataSummary.ReadOnly =
    zio.aws.fms.model.AppsListDataSummary.wrap(buildAwsValue())
}
object AppsListDataSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.AppsListDataSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.AppsListDataSummary =
      zio.aws.fms.model.AppsListDataSummary(
        listArn.map(value => value),
        listId.map(value => value),
        listName.map(value => value),
        appsList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def listArn: Optional[ResourceArn]
    def listId: Optional[ListId]
    def listName: Optional[ResourceName]
    def appsList: Optional[List[zio.aws.fms.model.App.ReadOnly]]
    def getListArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("listArn", listArn)
    def getListId: ZIO[Any, AwsError, ListId] =
      AwsError.unwrapOptionField("listId", listId)
    def getListName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("listName", listName)
    def getAppsList: ZIO[Any, AwsError, List[zio.aws.fms.model.App.ReadOnly]] =
      AwsError.unwrapOptionField("appsList", appsList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.AppsListDataSummary
  ) extends zio.aws.fms.model.AppsListDataSummary.ReadOnly {
    override val listArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.listArn())
      .map(value => zio.aws.fms.model.primitives.ResourceArn(value))
    override val listId: Optional[ListId] = zio.aws.core.internal
      .optionalFromNullable(impl.listId())
      .map(value => zio.aws.fms.model.primitives.ListId(value))
    override val listName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.listName())
      .map(value => zio.aws.fms.model.primitives.ResourceName(value))
    override val appsList: Optional[List[zio.aws.fms.model.App.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appsList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.App.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.AppsListDataSummary
  ): zio.aws.fms.model.AppsListDataSummary.ReadOnly = new Wrapper(impl)
}
