package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.AWSAccountId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociateAdminAccountRequest(adminAccount: AWSAccountId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.AssociateAdminAccountRequest = {
    import AssociateAdminAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.AssociateAdminAccountRequest
      .builder()
      .adminAccount(AWSAccountId.unwrap(adminAccount): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.AssociateAdminAccountRequest.ReadOnly =
    zio.aws.fms.model.AssociateAdminAccountRequest.wrap(buildAwsValue())
}
object AssociateAdminAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.AssociateAdminAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.AssociateAdminAccountRequest =
      zio.aws.fms.model.AssociateAdminAccountRequest(adminAccount)
    def adminAccount: AWSAccountId
    def getAdminAccount: ZIO[Any, Nothing, AWSAccountId] =
      ZIO.succeed(adminAccount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.AssociateAdminAccountRequest
  ) extends zio.aws.fms.model.AssociateAdminAccountRequest.ReadOnly {
    override val adminAccount: AWSAccountId =
      zio.aws.fms.model.primitives.AWSAccountId(impl.adminAccount())
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.AssociateAdminAccountRequest
  ): zio.aws.fms.model.AssociateAdminAccountRequest.ReadOnly = new Wrapper(impl)
}
