package zio.aws.fms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateThirdPartyFirewallResponse(
    thirdPartyFirewallStatus: Optional[
      zio.aws.fms.model.ThirdPartyFirewallAssociationStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.AssociateThirdPartyFirewallResponse = {
    import AssociateThirdPartyFirewallResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.AssociateThirdPartyFirewallResponse
      .builder()
      .optionallyWith(thirdPartyFirewallStatus.map(value => value.unwrap))(
        _.thirdPartyFirewallStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.fms.model.AssociateThirdPartyFirewallResponse.ReadOnly =
    zio.aws.fms.model.AssociateThirdPartyFirewallResponse.wrap(buildAwsValue())
}
object AssociateThirdPartyFirewallResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.AssociateThirdPartyFirewallResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.AssociateThirdPartyFirewallResponse =
      zio.aws.fms.model.AssociateThirdPartyFirewallResponse(
        thirdPartyFirewallStatus.map(value => value)
      )
    def thirdPartyFirewallStatus
        : Optional[zio.aws.fms.model.ThirdPartyFirewallAssociationStatus]
    def getThirdPartyFirewallStatus: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.ThirdPartyFirewallAssociationStatus
    ] = AwsError.unwrapOptionField(
      "thirdPartyFirewallStatus",
      thirdPartyFirewallStatus
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.AssociateThirdPartyFirewallResponse
  ) extends zio.aws.fms.model.AssociateThirdPartyFirewallResponse.ReadOnly {
    override val thirdPartyFirewallStatus
        : Optional[zio.aws.fms.model.ThirdPartyFirewallAssociationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thirdPartyFirewallStatus())
        .map(value =>
          zio.aws.fms.model.ThirdPartyFirewallAssociationStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.AssociateThirdPartyFirewallResponse
  ): zio.aws.fms.model.AssociateThirdPartyFirewallResponse.ReadOnly =
    new Wrapper(impl)
}
