package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.ListId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteAppsListRequest(listId: ListId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.DeleteAppsListRequest = {
    import DeleteAppsListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.DeleteAppsListRequest
      .builder()
      .listId(ListId.unwrap(listId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.DeleteAppsListRequest.ReadOnly =
    zio.aws.fms.model.DeleteAppsListRequest.wrap(buildAwsValue())
}
object DeleteAppsListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.DeleteAppsListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.DeleteAppsListRequest =
      zio.aws.fms.model.DeleteAppsListRequest(listId)
    def listId: ListId
    def getListId: ZIO[Any, Nothing, ListId] = ZIO.succeed(listId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.DeleteAppsListRequest
  ) extends zio.aws.fms.model.DeleteAppsListRequest.ReadOnly {
    override val listId: ListId =
      zio.aws.fms.model.primitives.ListId(impl.listId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.DeleteAppsListRequest
  ): zio.aws.fms.model.DeleteAppsListRequest.ReadOnly = new Wrapper(impl)
}
