package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.PolicyId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeletePolicyRequest(
    policyId: PolicyId,
    deleteAllPolicyResources: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.DeletePolicyRequest = {
    import DeletePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.DeletePolicyRequest
      .builder()
      .policyId(PolicyId.unwrap(policyId): java.lang.String)
      .optionallyWith(
        deleteAllPolicyResources.map(value => value: java.lang.Boolean)
      )(_.deleteAllPolicyResources)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.DeletePolicyRequest.ReadOnly =
    zio.aws.fms.model.DeletePolicyRequest.wrap(buildAwsValue())
}
object DeletePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.DeletePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.DeletePolicyRequest =
      zio.aws.fms.model.DeletePolicyRequest(
        policyId,
        deleteAllPolicyResources.map(value => value)
      )
    def policyId: PolicyId
    def deleteAllPolicyResources: Optional[Boolean]
    def getPolicyId: ZIO[Any, Nothing, PolicyId] = ZIO.succeed(policyId)
    def getDeleteAllPolicyResources: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("deleteAllPolicyResources", deleteAllPolicyResources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.DeletePolicyRequest
  ) extends zio.aws.fms.model.DeletePolicyRequest.ReadOnly {
    override val policyId: PolicyId =
      zio.aws.fms.model.primitives.PolicyId(impl.policyId())
    override val deleteAllPolicyResources: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deleteAllPolicyResources())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.DeletePolicyRequest
  ): zio.aws.fms.model.DeletePolicyRequest.ReadOnly = new Wrapper(impl)
}
