package zio.aws.fms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociateThirdPartyFirewallResponse(
    thirdPartyFirewallStatus: Optional[
      zio.aws.fms.model.ThirdPartyFirewallAssociationStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.DisassociateThirdPartyFirewallResponse = {
    import DisassociateThirdPartyFirewallResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.DisassociateThirdPartyFirewallResponse
      .builder()
      .optionallyWith(thirdPartyFirewallStatus.map(value => value.unwrap))(
        _.thirdPartyFirewallStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.fms.model.DisassociateThirdPartyFirewallResponse.ReadOnly =
    zio.aws.fms.model.DisassociateThirdPartyFirewallResponse
      .wrap(buildAwsValue())
}
object DisassociateThirdPartyFirewallResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.DisassociateThirdPartyFirewallResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.DisassociateThirdPartyFirewallResponse =
      zio.aws.fms.model.DisassociateThirdPartyFirewallResponse(
        thirdPartyFirewallStatus.map(value => value)
      )
    def thirdPartyFirewallStatus
        : Optional[zio.aws.fms.model.ThirdPartyFirewallAssociationStatus]
    def getThirdPartyFirewallStatus: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.ThirdPartyFirewallAssociationStatus
    ] = AwsError.unwrapOptionField(
      "thirdPartyFirewallStatus",
      thirdPartyFirewallStatus
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.DisassociateThirdPartyFirewallResponse
  ) extends zio.aws.fms.model.DisassociateThirdPartyFirewallResponse.ReadOnly {
    override val thirdPartyFirewallStatus
        : Optional[zio.aws.fms.model.ThirdPartyFirewallAssociationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thirdPartyFirewallStatus())
        .map(value =>
          zio.aws.fms.model.ThirdPartyFirewallAssociationStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.DisassociateThirdPartyFirewallResponse
  ): zio.aws.fms.model.DisassociateThirdPartyFirewallResponse.ReadOnly =
    new Wrapper(impl)
}
