package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.LengthBoundedString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EC2CreateRouteTableAction(
    description: Optional[LengthBoundedString] = Optional.Absent,
    vpcId: zio.aws.fms.model.ActionTarget
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.EC2CreateRouteTableAction = {
    import EC2CreateRouteTableAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.EC2CreateRouteTableAction
      .builder()
      .optionallyWith(
        description.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .vpcId(vpcId.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.fms.model.EC2CreateRouteTableAction.ReadOnly =
    zio.aws.fms.model.EC2CreateRouteTableAction.wrap(buildAwsValue())
}
object EC2CreateRouteTableAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.EC2CreateRouteTableAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.EC2CreateRouteTableAction =
      zio.aws.fms.model.EC2CreateRouteTableAction(
        description.map(value => value),
        vpcId.asEditable
      )
    def description: Optional[LengthBoundedString]
    def vpcId: zio.aws.fms.model.ActionTarget.ReadOnly
    def getDescription: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField("description", description)
    def getVpcId: ZIO[Any, Nothing, zio.aws.fms.model.ActionTarget.ReadOnly] =
      ZIO.succeed(vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.EC2CreateRouteTableAction
  ) extends zio.aws.fms.model.EC2CreateRouteTableAction.ReadOnly {
    override val description: Optional[LengthBoundedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val vpcId: zio.aws.fms.model.ActionTarget.ReadOnly =
      zio.aws.fms.model.ActionTarget.wrap(impl.vpcId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.EC2CreateRouteTableAction
  ): zio.aws.fms.model.EC2CreateRouteTableAction.ReadOnly = new Wrapper(impl)
}
