package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.LengthBoundedString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EC2ReplaceRouteTableAssociationAction(
    description: Optional[LengthBoundedString] = Optional.Absent,
    associationId: zio.aws.fms.model.ActionTarget,
    routeTableId: zio.aws.fms.model.ActionTarget
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.EC2ReplaceRouteTableAssociationAction = {
    import EC2ReplaceRouteTableAssociationAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.EC2ReplaceRouteTableAssociationAction
      .builder()
      .optionallyWith(
        description.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .associationId(associationId.buildAwsValue())
      .routeTableId(routeTableId.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.fms.model.EC2ReplaceRouteTableAssociationAction.ReadOnly =
    zio.aws.fms.model.EC2ReplaceRouteTableAssociationAction
      .wrap(buildAwsValue())
}
object EC2ReplaceRouteTableAssociationAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.EC2ReplaceRouteTableAssociationAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.EC2ReplaceRouteTableAssociationAction =
      zio.aws.fms.model.EC2ReplaceRouteTableAssociationAction(
        description.map(value => value),
        associationId.asEditable,
        routeTableId.asEditable
      )
    def description: Optional[LengthBoundedString]
    def associationId: zio.aws.fms.model.ActionTarget.ReadOnly
    def routeTableId: zio.aws.fms.model.ActionTarget.ReadOnly
    def getDescription: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField("description", description)
    def getAssociationId
        : ZIO[Any, Nothing, zio.aws.fms.model.ActionTarget.ReadOnly] =
      ZIO.succeed(associationId)
    def getRouteTableId
        : ZIO[Any, Nothing, zio.aws.fms.model.ActionTarget.ReadOnly] =
      ZIO.succeed(routeTableId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.EC2ReplaceRouteTableAssociationAction
  ) extends zio.aws.fms.model.EC2ReplaceRouteTableAssociationAction.ReadOnly {
    override val description: Optional[LengthBoundedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val associationId: zio.aws.fms.model.ActionTarget.ReadOnly =
      zio.aws.fms.model.ActionTarget.wrap(impl.associationId())
    override val routeTableId: zio.aws.fms.model.ActionTarget.ReadOnly =
      zio.aws.fms.model.ActionTarget.wrap(impl.routeTableId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.EC2ReplaceRouteTableAssociationAction
  ): zio.aws.fms.model.EC2ReplaceRouteTableAssociationAction.ReadOnly =
    new Wrapper(impl)
}
