package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{AWSAccountId, PolicyId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetComplianceDetailRequest(
    policyId: PolicyId,
    memberAccount: AWSAccountId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.GetComplianceDetailRequest = {
    import GetComplianceDetailRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.GetComplianceDetailRequest
      .builder()
      .policyId(PolicyId.unwrap(policyId): java.lang.String)
      .memberAccount(AWSAccountId.unwrap(memberAccount): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.GetComplianceDetailRequest.ReadOnly =
    zio.aws.fms.model.GetComplianceDetailRequest.wrap(buildAwsValue())
}
object GetComplianceDetailRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.GetComplianceDetailRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.GetComplianceDetailRequest =
      zio.aws.fms.model.GetComplianceDetailRequest(policyId, memberAccount)
    def policyId: PolicyId
    def memberAccount: AWSAccountId
    def getPolicyId: ZIO[Any, Nothing, PolicyId] = ZIO.succeed(policyId)
    def getMemberAccount: ZIO[Any, Nothing, AWSAccountId] =
      ZIO.succeed(memberAccount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.GetComplianceDetailRequest
  ) extends zio.aws.fms.model.GetComplianceDetailRequest.ReadOnly {
    override val policyId: PolicyId =
      zio.aws.fms.model.primitives.PolicyId(impl.policyId())
    override val memberAccount: AWSAccountId =
      zio.aws.fms.model.primitives.AWSAccountId(impl.memberAccount())
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.GetComplianceDetailRequest
  ): zio.aws.fms.model.GetComplianceDetailRequest.ReadOnly = new Wrapper(impl)
}
