package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.PolicyId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetPolicyRequest(policyId: PolicyId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.GetPolicyRequest = {
    import GetPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.GetPolicyRequest
      .builder()
      .policyId(PolicyId.unwrap(policyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.GetPolicyRequest.ReadOnly =
    zio.aws.fms.model.GetPolicyRequest.wrap(buildAwsValue())
}
object GetPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.GetPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.GetPolicyRequest =
      zio.aws.fms.model.GetPolicyRequest(policyId)
    def policyId: PolicyId
    def getPolicyId: ZIO[Any, Nothing, PolicyId] = ZIO.succeed(policyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.GetPolicyRequest
  ) extends zio.aws.fms.model.GetPolicyRequest.ReadOnly {
    override val policyId: PolicyId =
      zio.aws.fms.model.primitives.PolicyId(impl.policyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.GetPolicyRequest
  ): zio.aws.fms.model.GetPolicyRequest.ReadOnly = new Wrapper(impl)
}
