package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.ResourceArn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetPolicyResponse(
    policy: Optional[zio.aws.fms.model.Policy] = Optional.Absent,
    policyArn: Optional[ResourceArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.GetPolicyResponse = {
    import GetPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.GetPolicyResponse
      .builder()
      .optionallyWith(policy.map(value => value.buildAwsValue()))(_.policy)
      .optionallyWith(
        policyArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.policyArn)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.GetPolicyResponse.ReadOnly =
    zio.aws.fms.model.GetPolicyResponse.wrap(buildAwsValue())
}
object GetPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.GetPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.GetPolicyResponse =
      zio.aws.fms.model.GetPolicyResponse(
        policy.map(value => value.asEditable),
        policyArn.map(value => value)
      )
    def policy: Optional[zio.aws.fms.model.Policy.ReadOnly]
    def policyArn: Optional[ResourceArn]
    def getPolicy: ZIO[Any, AwsError, zio.aws.fms.model.Policy.ReadOnly] =
      AwsError.unwrapOptionField("policy", policy)
    def getPolicyArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("policyArn", policyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.GetPolicyResponse
  ) extends zio.aws.fms.model.GetPolicyResponse.ReadOnly {
    override val policy: Optional[zio.aws.fms.model.Policy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policy())
        .map(value => zio.aws.fms.model.Policy.wrap(value))
    override val policyArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.policyArn())
      .map(value => zio.aws.fms.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.GetPolicyResponse
  ): zio.aws.fms.model.GetPolicyResponse.ReadOnly = new Wrapper(impl)
}
