package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.ListId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetProtocolsListRequest(
    listId: ListId,
    defaultList: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.GetProtocolsListRequest = {
    import GetProtocolsListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.GetProtocolsListRequest
      .builder()
      .listId(ListId.unwrap(listId): java.lang.String)
      .optionallyWith(defaultList.map(value => value: java.lang.Boolean))(
        _.defaultList
      )
      .build()
  }
  def asReadOnly: zio.aws.fms.model.GetProtocolsListRequest.ReadOnly =
    zio.aws.fms.model.GetProtocolsListRequest.wrap(buildAwsValue())
}
object GetProtocolsListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.GetProtocolsListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.GetProtocolsListRequest =
      zio.aws.fms.model
        .GetProtocolsListRequest(listId, defaultList.map(value => value))
    def listId: ListId
    def defaultList: Optional[Boolean]
    def getListId: ZIO[Any, Nothing, ListId] = ZIO.succeed(listId)
    def getDefaultList: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("defaultList", defaultList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.GetProtocolsListRequest
  ) extends zio.aws.fms.model.GetProtocolsListRequest.ReadOnly {
    override val listId: ListId =
      zio.aws.fms.model.primitives.ListId(impl.listId())
    override val defaultList: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultList())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.GetProtocolsListRequest
  ): zio.aws.fms.model.GetProtocolsListRequest.ReadOnly = new Wrapper(impl)
}
