package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.ResourceArn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetProtocolsListResponse(
    protocolsList: Optional[zio.aws.fms.model.ProtocolsListData] =
      Optional.Absent,
    protocolsListArn: Optional[ResourceArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.GetProtocolsListResponse = {
    import GetProtocolsListResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.GetProtocolsListResponse
      .builder()
      .optionallyWith(protocolsList.map(value => value.buildAwsValue()))(
        _.protocolsList
      )
      .optionallyWith(
        protocolsListArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.protocolsListArn)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.GetProtocolsListResponse.ReadOnly =
    zio.aws.fms.model.GetProtocolsListResponse.wrap(buildAwsValue())
}
object GetProtocolsListResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.GetProtocolsListResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.GetProtocolsListResponse =
      zio.aws.fms.model.GetProtocolsListResponse(
        protocolsList.map(value => value.asEditable),
        protocolsListArn.map(value => value)
      )
    def protocolsList: Optional[zio.aws.fms.model.ProtocolsListData.ReadOnly]
    def protocolsListArn: Optional[ResourceArn]
    def getProtocolsList
        : ZIO[Any, AwsError, zio.aws.fms.model.ProtocolsListData.ReadOnly] =
      AwsError.unwrapOptionField("protocolsList", protocolsList)
    def getProtocolsListArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("protocolsListArn", protocolsListArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.GetProtocolsListResponse
  ) extends zio.aws.fms.model.GetProtocolsListResponse.ReadOnly {
    override val protocolsList
        : Optional[zio.aws.fms.model.ProtocolsListData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocolsList())
        .map(value => zio.aws.fms.model.ProtocolsListData.wrap(value))
    override val protocolsListArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.protocolsListArn())
      .map(value => zio.aws.fms.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.GetProtocolsListResponse
  ): zio.aws.fms.model.GetProtocolsListResponse.ReadOnly = new Wrapper(impl)
}
