package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{
  ResourceType,
  ResourceId,
  AWSAccountId,
  PolicyId
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetViolationDetailsRequest(
    policyId: PolicyId,
    memberAccount: AWSAccountId,
    resourceId: ResourceId,
    resourceType: ResourceType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.GetViolationDetailsRequest = {
    import GetViolationDetailsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.GetViolationDetailsRequest
      .builder()
      .policyId(PolicyId.unwrap(policyId): java.lang.String)
      .memberAccount(AWSAccountId.unwrap(memberAccount): java.lang.String)
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .resourceType(ResourceType.unwrap(resourceType): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.GetViolationDetailsRequest.ReadOnly =
    zio.aws.fms.model.GetViolationDetailsRequest.wrap(buildAwsValue())
}
object GetViolationDetailsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.GetViolationDetailsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.GetViolationDetailsRequest =
      zio.aws.fms.model.GetViolationDetailsRequest(
        policyId,
        memberAccount,
        resourceId,
        resourceType
      )
    def policyId: PolicyId
    def memberAccount: AWSAccountId
    def resourceId: ResourceId
    def resourceType: ResourceType
    def getPolicyId: ZIO[Any, Nothing, PolicyId] = ZIO.succeed(policyId)
    def getMemberAccount: ZIO[Any, Nothing, AWSAccountId] =
      ZIO.succeed(memberAccount)
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
    def getResourceType: ZIO[Any, Nothing, ResourceType] =
      ZIO.succeed(resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.GetViolationDetailsRequest
  ) extends zio.aws.fms.model.GetViolationDetailsRequest.ReadOnly {
    override val policyId: PolicyId =
      zio.aws.fms.model.primitives.PolicyId(impl.policyId())
    override val memberAccount: AWSAccountId =
      zio.aws.fms.model.primitives.AWSAccountId(impl.memberAccount())
    override val resourceId: ResourceId =
      zio.aws.fms.model.primitives.ResourceId(impl.resourceId())
    override val resourceType: ResourceType =
      zio.aws.fms.model.primitives.ResourceType(impl.resourceType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.GetViolationDetailsRequest
  ): zio.aws.fms.model.GetViolationDetailsRequest.ReadOnly = new Wrapper(impl)
}
