package zio.aws.fms.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fms.model.primitives.{PaginationMaxResults, PaginationToken}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAppsListsRequest(
    defaultLists: Optional[Boolean] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: PaginationMaxResults
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ListAppsListsRequest = {
    import ListAppsListsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ListAppsListsRequest
      .builder()
      .optionallyWith(defaultLists.map(value => value: java.lang.Boolean))(
        _.defaultLists
      )
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .maxResults(PaginationMaxResults.unwrap(maxResults): Integer)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.ListAppsListsRequest.ReadOnly =
    zio.aws.fms.model.ListAppsListsRequest.wrap(buildAwsValue())
}
object ListAppsListsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.ListAppsListsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.ListAppsListsRequest =
      zio.aws.fms.model.ListAppsListsRequest(
        defaultLists.map(value => value),
        nextToken.map(value => value),
        maxResults
      )
    def defaultLists: Optional[Boolean]
    def nextToken: Optional[PaginationToken]
    def maxResults: PaginationMaxResults
    def getDefaultLists: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("defaultLists", defaultLists)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, Nothing, PaginationMaxResults] =
      ZIO.succeed(maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ListAppsListsRequest
  ) extends zio.aws.fms.model.ListAppsListsRequest.ReadOnly {
    override val defaultLists: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultLists())
      .map(value => value: Boolean)
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.fms.model.primitives.PaginationToken(value))
    override val maxResults: PaginationMaxResults =
      zio.aws.fms.model.primitives.PaginationMaxResults(impl.maxResults())
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ListAppsListsRequest
  ): zio.aws.fms.model.ListAppsListsRequest.ReadOnly = new Wrapper(impl)
}
