package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAppsListsResponse(
    appsLists: Optional[Iterable[zio.aws.fms.model.AppsListDataSummary]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ListAppsListsResponse = {
    import ListAppsListsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ListAppsListsResponse
      .builder()
      .optionallyWith(
        appsLists.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.appsLists)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.ListAppsListsResponse.ReadOnly =
    zio.aws.fms.model.ListAppsListsResponse.wrap(buildAwsValue())
}
object ListAppsListsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.ListAppsListsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.ListAppsListsResponse =
      zio.aws.fms.model.ListAppsListsResponse(
        appsLists.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def appsLists
        : Optional[List[zio.aws.fms.model.AppsListDataSummary.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getAppsLists: ZIO[Any, AwsError, List[
      zio.aws.fms.model.AppsListDataSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("appsLists", appsLists)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ListAppsListsResponse
  ) extends zio.aws.fms.model.ListAppsListsResponse.ReadOnly {
    override val appsLists
        : Optional[List[zio.aws.fms.model.AppsListDataSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appsLists())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.AppsListDataSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.fms.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ListAppsListsResponse
  ): zio.aws.fms.model.ListAppsListsResponse.ReadOnly = new Wrapper(impl)
}
