package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{PaginationToken, AWSAccountId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListMemberAccountsResponse(
    memberAccounts: Optional[Iterable[AWSAccountId]] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ListMemberAccountsResponse = {
    import ListMemberAccountsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ListMemberAccountsResponse
      .builder()
      .optionallyWith(
        memberAccounts.map(value =>
          value.map { item =>
            AWSAccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.memberAccounts)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.ListMemberAccountsResponse.ReadOnly =
    zio.aws.fms.model.ListMemberAccountsResponse.wrap(buildAwsValue())
}
object ListMemberAccountsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.ListMemberAccountsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.ListMemberAccountsResponse =
      zio.aws.fms.model.ListMemberAccountsResponse(
        memberAccounts.map(value => value),
        nextToken.map(value => value)
      )
    def memberAccounts: Optional[List[AWSAccountId]]
    def nextToken: Optional[PaginationToken]
    def getMemberAccounts: ZIO[Any, AwsError, List[AWSAccountId]] =
      AwsError.unwrapOptionField("memberAccounts", memberAccounts)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ListMemberAccountsResponse
  ) extends zio.aws.fms.model.ListMemberAccountsResponse.ReadOnly {
    override val memberAccounts: Optional[List[AWSAccountId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.memberAccounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.primitives.AWSAccountId(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.fms.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ListMemberAccountsResponse
  ): zio.aws.fms.model.ListMemberAccountsResponse.ReadOnly = new Wrapper(impl)
}
