package zio.aws.fms.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fms.model.primitives.{PaginationMaxResults, PaginationToken}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPoliciesRequest(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[PaginationMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ListPoliciesRequest = {
    import ListPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ListPoliciesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => PaginationMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.ListPoliciesRequest.ReadOnly =
    zio.aws.fms.model.ListPoliciesRequest.wrap(buildAwsValue())
}
object ListPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.ListPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.ListPoliciesRequest =
      zio.aws.fms.model.ListPoliciesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[PaginationMaxResults]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PaginationMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ListPoliciesRequest
  ) extends zio.aws.fms.model.ListPoliciesRequest.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.fms.model.primitives.PaginationToken(value))
    override val maxResults: Optional[PaginationMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value => zio.aws.fms.model.primitives.PaginationMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ListPoliciesRequest
  ): zio.aws.fms.model.ListPoliciesRequest.ReadOnly = new Wrapper(impl)
}
