package zio.aws.fms.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fms.model.primitives.{PaginationMaxResults, PaginationToken}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListThirdPartyFirewallFirewallPoliciesRequest(
    thirdPartyFirewall: zio.aws.fms.model.ThirdPartyFirewall,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: PaginationMaxResults
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ListThirdPartyFirewallFirewallPoliciesRequest = {
    import ListThirdPartyFirewallFirewallPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ListThirdPartyFirewallFirewallPoliciesRequest
      .builder()
      .thirdPartyFirewall(thirdPartyFirewall.unwrap)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .maxResults(PaginationMaxResults.unwrap(maxResults): Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.fms.model.ListThirdPartyFirewallFirewallPoliciesRequest.ReadOnly =
    zio.aws.fms.model.ListThirdPartyFirewallFirewallPoliciesRequest
      .wrap(buildAwsValue())
}
object ListThirdPartyFirewallFirewallPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.ListThirdPartyFirewallFirewallPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.fms.model.ListThirdPartyFirewallFirewallPoliciesRequest =
      zio.aws.fms.model.ListThirdPartyFirewallFirewallPoliciesRequest(
        thirdPartyFirewall,
        nextToken.map(value => value),
        maxResults
      )
    def thirdPartyFirewall: zio.aws.fms.model.ThirdPartyFirewall
    def nextToken: Optional[PaginationToken]
    def maxResults: PaginationMaxResults
    def getThirdPartyFirewall
        : ZIO[Any, Nothing, zio.aws.fms.model.ThirdPartyFirewall] =
      ZIO.succeed(thirdPartyFirewall)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, Nothing, PaginationMaxResults] =
      ZIO.succeed(maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ListThirdPartyFirewallFirewallPoliciesRequest
  ) extends zio.aws.fms.model.ListThirdPartyFirewallFirewallPoliciesRequest.ReadOnly {
    override val thirdPartyFirewall: zio.aws.fms.model.ThirdPartyFirewall =
      zio.aws.fms.model.ThirdPartyFirewall.wrap(impl.thirdPartyFirewall())
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.fms.model.primitives.PaginationToken(value))
    override val maxResults: PaginationMaxResults =
      zio.aws.fms.model.primitives.PaginationMaxResults(impl.maxResults())
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ListThirdPartyFirewallFirewallPoliciesRequest
  ): zio.aws.fms.model.ListThirdPartyFirewallFirewallPoliciesRequest.ReadOnly =
    new Wrapper(impl)
}
