package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.ResourceId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkFirewallInvalidRouteConfigurationViolation(
    affectedSubnets: Optional[Iterable[ResourceId]] = Optional.Absent,
    routeTableId: Optional[ResourceId] = Optional.Absent,
    isRouteTableUsedInDifferentAZ: Optional[Boolean] = Optional.Absent,
    violatingRoute: Optional[zio.aws.fms.model.Route] = Optional.Absent,
    currentFirewallSubnetRouteTable: Optional[ResourceId] = Optional.Absent,
    expectedFirewallEndpoint: Optional[ResourceId] = Optional.Absent,
    actualFirewallEndpoint: Optional[ResourceId] = Optional.Absent,
    expectedFirewallSubnetId: Optional[ResourceId] = Optional.Absent,
    actualFirewallSubnetId: Optional[ResourceId] = Optional.Absent,
    expectedFirewallSubnetRoutes: Optional[
      Iterable[zio.aws.fms.model.ExpectedRoute]
    ] = Optional.Absent,
    actualFirewallSubnetRoutes: Optional[Iterable[zio.aws.fms.model.Route]] =
      Optional.Absent,
    internetGatewayId: Optional[ResourceId] = Optional.Absent,
    currentInternetGatewayRouteTable: Optional[ResourceId] = Optional.Absent,
    expectedInternetGatewayRoutes: Optional[
      Iterable[zio.aws.fms.model.ExpectedRoute]
    ] = Optional.Absent,
    actualInternetGatewayRoutes: Optional[Iterable[zio.aws.fms.model.Route]] =
      Optional.Absent,
    vpcId: Optional[ResourceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.NetworkFirewallInvalidRouteConfigurationViolation = {
    import NetworkFirewallInvalidRouteConfigurationViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.NetworkFirewallInvalidRouteConfigurationViolation
      .builder()
      .optionallyWith(
        affectedSubnets.map(value =>
          value.map { item =>
            ResourceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.affectedSubnets)
      .optionallyWith(
        routeTableId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.routeTableId)
      .optionallyWith(
        isRouteTableUsedInDifferentAZ.map(value => value: java.lang.Boolean)
      )(_.isRouteTableUsedInDifferentAZ)
      .optionallyWith(violatingRoute.map(value => value.buildAwsValue()))(
        _.violatingRoute
      )
      .optionallyWith(
        currentFirewallSubnetRouteTable.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.currentFirewallSubnetRouteTable)
      .optionallyWith(
        expectedFirewallEndpoint.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.expectedFirewallEndpoint)
      .optionallyWith(
        actualFirewallEndpoint.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.actualFirewallEndpoint)
      .optionallyWith(
        expectedFirewallSubnetId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.expectedFirewallSubnetId)
      .optionallyWith(
        actualFirewallSubnetId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.actualFirewallSubnetId)
      .optionallyWith(
        expectedFirewallSubnetRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.expectedFirewallSubnetRoutes)
      .optionallyWith(
        actualFirewallSubnetRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actualFirewallSubnetRoutes)
      .optionallyWith(
        internetGatewayId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.internetGatewayId)
      .optionallyWith(
        currentInternetGatewayRouteTable.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.currentInternetGatewayRouteTable)
      .optionallyWith(
        expectedInternetGatewayRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.expectedInternetGatewayRoutes)
      .optionallyWith(
        actualInternetGatewayRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actualInternetGatewayRoutes)
      .optionallyWith(
        vpcId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly
      : zio.aws.fms.model.NetworkFirewallInvalidRouteConfigurationViolation.ReadOnly =
    zio.aws.fms.model.NetworkFirewallInvalidRouteConfigurationViolation
      .wrap(buildAwsValue())
}
object NetworkFirewallInvalidRouteConfigurationViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.NetworkFirewallInvalidRouteConfigurationViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.fms.model.NetworkFirewallInvalidRouteConfigurationViolation =
      zio.aws.fms.model.NetworkFirewallInvalidRouteConfigurationViolation(
        affectedSubnets.map(value => value),
        routeTableId.map(value => value),
        isRouteTableUsedInDifferentAZ.map(value => value),
        violatingRoute.map(value => value.asEditable),
        currentFirewallSubnetRouteTable.map(value => value),
        expectedFirewallEndpoint.map(value => value),
        actualFirewallEndpoint.map(value => value),
        expectedFirewallSubnetId.map(value => value),
        actualFirewallSubnetId.map(value => value),
        expectedFirewallSubnetRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        actualFirewallSubnetRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        internetGatewayId.map(value => value),
        currentInternetGatewayRouteTable.map(value => value),
        expectedInternetGatewayRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        actualInternetGatewayRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcId.map(value => value)
      )
    def affectedSubnets: Optional[List[ResourceId]]
    def routeTableId: Optional[ResourceId]
    def isRouteTableUsedInDifferentAZ: Optional[Boolean]
    def violatingRoute: Optional[zio.aws.fms.model.Route.ReadOnly]
    def currentFirewallSubnetRouteTable: Optional[ResourceId]
    def expectedFirewallEndpoint: Optional[ResourceId]
    def actualFirewallEndpoint: Optional[ResourceId]
    def expectedFirewallSubnetId: Optional[ResourceId]
    def actualFirewallSubnetId: Optional[ResourceId]
    def expectedFirewallSubnetRoutes
        : Optional[List[zio.aws.fms.model.ExpectedRoute.ReadOnly]]
    def actualFirewallSubnetRoutes
        : Optional[List[zio.aws.fms.model.Route.ReadOnly]]
    def internetGatewayId: Optional[ResourceId]
    def currentInternetGatewayRouteTable: Optional[ResourceId]
    def expectedInternetGatewayRoutes
        : Optional[List[zio.aws.fms.model.ExpectedRoute.ReadOnly]]
    def actualInternetGatewayRoutes
        : Optional[List[zio.aws.fms.model.Route.ReadOnly]]
    def vpcId: Optional[ResourceId]
    def getAffectedSubnets: ZIO[Any, AwsError, List[ResourceId]] =
      AwsError.unwrapOptionField("affectedSubnets", affectedSubnets)
    def getRouteTableId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("routeTableId", routeTableId)
    def getIsRouteTableUsedInDifferentAZ: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "isRouteTableUsedInDifferentAZ",
        isRouteTableUsedInDifferentAZ
      )
    def getViolatingRoute
        : ZIO[Any, AwsError, zio.aws.fms.model.Route.ReadOnly] =
      AwsError.unwrapOptionField("violatingRoute", violatingRoute)
    def getCurrentFirewallSubnetRouteTable: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField(
        "currentFirewallSubnetRouteTable",
        currentFirewallSubnetRouteTable
      )
    def getExpectedFirewallEndpoint: ZIO[Any, AwsError, ResourceId] = AwsError
      .unwrapOptionField("expectedFirewallEndpoint", expectedFirewallEndpoint)
    def getActualFirewallEndpoint: ZIO[Any, AwsError, ResourceId] = AwsError
      .unwrapOptionField("actualFirewallEndpoint", actualFirewallEndpoint)
    def getExpectedFirewallSubnetId: ZIO[Any, AwsError, ResourceId] = AwsError
      .unwrapOptionField("expectedFirewallSubnetId", expectedFirewallSubnetId)
    def getActualFirewallSubnetId: ZIO[Any, AwsError, ResourceId] = AwsError
      .unwrapOptionField("actualFirewallSubnetId", actualFirewallSubnetId)
    def getExpectedFirewallSubnetRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.ExpectedRoute.ReadOnly]] =
      AwsError.unwrapOptionField(
        "expectedFirewallSubnetRoutes",
        expectedFirewallSubnetRoutes
      )
    def getActualFirewallSubnetRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.Route.ReadOnly]] =
      AwsError.unwrapOptionField(
        "actualFirewallSubnetRoutes",
        actualFirewallSubnetRoutes
      )
    def getInternetGatewayId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("internetGatewayId", internetGatewayId)
    def getCurrentInternetGatewayRouteTable: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField(
        "currentInternetGatewayRouteTable",
        currentInternetGatewayRouteTable
      )
    def getExpectedInternetGatewayRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.ExpectedRoute.ReadOnly]] =
      AwsError.unwrapOptionField(
        "expectedInternetGatewayRoutes",
        expectedInternetGatewayRoutes
      )
    def getActualInternetGatewayRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.Route.ReadOnly]] =
      AwsError.unwrapOptionField(
        "actualInternetGatewayRoutes",
        actualInternetGatewayRoutes
      )
    def getVpcId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallInvalidRouteConfigurationViolation
  ) extends zio.aws.fms.model.NetworkFirewallInvalidRouteConfigurationViolation.ReadOnly {
    override val affectedSubnets: Optional[List[ResourceId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.affectedSubnets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.primitives.ResourceId(item)
          }.toList
        )
    override val routeTableId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.routeTableId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val isRouteTableUsedInDifferentAZ: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isRouteTableUsedInDifferentAZ())
        .map(value => value: Boolean)
    override val violatingRoute: Optional[zio.aws.fms.model.Route.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.violatingRoute())
        .map(value => zio.aws.fms.model.Route.wrap(value))
    override val currentFirewallSubnetRouteTable: Optional[ResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentFirewallSubnetRouteTable())
        .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val expectedFirewallEndpoint: Optional[ResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedFirewallEndpoint())
        .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val actualFirewallEndpoint: Optional[ResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actualFirewallEndpoint())
        .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val expectedFirewallSubnetId: Optional[ResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedFirewallSubnetId())
        .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val actualFirewallSubnetId: Optional[ResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actualFirewallSubnetId())
        .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val expectedFirewallSubnetRoutes
        : Optional[List[zio.aws.fms.model.ExpectedRoute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedFirewallSubnetRoutes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.ExpectedRoute.wrap(item)
          }.toList
        )
    override val actualFirewallSubnetRoutes
        : Optional[List[zio.aws.fms.model.Route.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actualFirewallSubnetRoutes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.Route.wrap(item)
          }.toList
        )
    override val internetGatewayId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.internetGatewayId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val currentInternetGatewayRouteTable: Optional[ResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentInternetGatewayRouteTable())
        .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val expectedInternetGatewayRoutes
        : Optional[List[zio.aws.fms.model.ExpectedRoute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedInternetGatewayRoutes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.ExpectedRoute.wrap(item)
          }.toList
        )
    override val actualInternetGatewayRoutes
        : Optional[List[zio.aws.fms.model.Route.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actualInternetGatewayRoutes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.Route.wrap(item)
          }.toList
        )
    override val vpcId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallInvalidRouteConfigurationViolation
  ): zio.aws.fms.model.NetworkFirewallInvalidRouteConfigurationViolation.ReadOnly =
    new Wrapper(impl)
}
