package zio.aws.fms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkFirewallPolicy(
    firewallDeploymentModel: Optional[
      zio.aws.fms.model.FirewallDeploymentModel
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.NetworkFirewallPolicy = {
    import NetworkFirewallPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.NetworkFirewallPolicy
      .builder()
      .optionallyWith(firewallDeploymentModel.map(value => value.unwrap))(
        _.firewallDeploymentModel
      )
      .build()
  }
  def asReadOnly: zio.aws.fms.model.NetworkFirewallPolicy.ReadOnly =
    zio.aws.fms.model.NetworkFirewallPolicy.wrap(buildAwsValue())
}
object NetworkFirewallPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.NetworkFirewallPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.NetworkFirewallPolicy = zio.aws.fms.model
      .NetworkFirewallPolicy(firewallDeploymentModel.map(value => value))
    def firewallDeploymentModel
        : Optional[zio.aws.fms.model.FirewallDeploymentModel]
    def getFirewallDeploymentModel
        : ZIO[Any, AwsError, zio.aws.fms.model.FirewallDeploymentModel] =
      AwsError.unwrapOptionField(
        "firewallDeploymentModel",
        firewallDeploymentModel
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallPolicy
  ) extends zio.aws.fms.model.NetworkFirewallPolicy.ReadOnly {
    override val firewallDeploymentModel
        : Optional[zio.aws.fms.model.FirewallDeploymentModel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallDeploymentModel())
        .map(value => zio.aws.fms.model.FirewallDeploymentModel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallPolicy
  ): zio.aws.fms.model.NetworkFirewallPolicy.ReadOnly = new Wrapper(impl)
}
