package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.NetworkFirewallAction
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkFirewallPolicyDescription(
    statelessRuleGroups: Optional[
      Iterable[zio.aws.fms.model.StatelessRuleGroup]
    ] = Optional.Absent,
    statelessDefaultActions: Optional[Iterable[NetworkFirewallAction]] =
      Optional.Absent,
    statelessFragmentDefaultActions: Optional[Iterable[NetworkFirewallAction]] =
      Optional.Absent,
    statelessCustomActions: Optional[Iterable[NetworkFirewallAction]] =
      Optional.Absent,
    statefulRuleGroups: Optional[
      Iterable[zio.aws.fms.model.StatefulRuleGroup]
    ] = Optional.Absent,
    statefulDefaultActions: Optional[Iterable[NetworkFirewallAction]] =
      Optional.Absent,
    statefulEngineOptions: Optional[zio.aws.fms.model.StatefulEngineOptions] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.NetworkFirewallPolicyDescription = {
    import NetworkFirewallPolicyDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.NetworkFirewallPolicyDescription
      .builder()
      .optionallyWith(
        statelessRuleGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statelessRuleGroups)
      .optionallyWith(
        statelessDefaultActions.map(value =>
          value.map { item =>
            NetworkFirewallAction.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.statelessDefaultActions)
      .optionallyWith(
        statelessFragmentDefaultActions.map(value =>
          value.map { item =>
            NetworkFirewallAction.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.statelessFragmentDefaultActions)
      .optionallyWith(
        statelessCustomActions.map(value =>
          value.map { item =>
            NetworkFirewallAction.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.statelessCustomActions)
      .optionallyWith(
        statefulRuleGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statefulRuleGroups)
      .optionallyWith(
        statefulDefaultActions.map(value =>
          value.map { item =>
            NetworkFirewallAction.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.statefulDefaultActions)
      .optionallyWith(
        statefulEngineOptions.map(value => value.buildAwsValue())
      )(_.statefulEngineOptions)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.NetworkFirewallPolicyDescription.ReadOnly =
    zio.aws.fms.model.NetworkFirewallPolicyDescription.wrap(buildAwsValue())
}
object NetworkFirewallPolicyDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.NetworkFirewallPolicyDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.NetworkFirewallPolicyDescription =
      zio.aws.fms.model.NetworkFirewallPolicyDescription(
        statelessRuleGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statelessDefaultActions.map(value => value),
        statelessFragmentDefaultActions.map(value => value),
        statelessCustomActions.map(value => value),
        statefulRuleGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statefulDefaultActions.map(value => value),
        statefulEngineOptions.map(value => value.asEditable)
      )
    def statelessRuleGroups
        : Optional[List[zio.aws.fms.model.StatelessRuleGroup.ReadOnly]]
    def statelessDefaultActions: Optional[List[NetworkFirewallAction]]
    def statelessFragmentDefaultActions: Optional[List[NetworkFirewallAction]]
    def statelessCustomActions: Optional[List[NetworkFirewallAction]]
    def statefulRuleGroups
        : Optional[List[zio.aws.fms.model.StatefulRuleGroup.ReadOnly]]
    def statefulDefaultActions: Optional[List[NetworkFirewallAction]]
    def statefulEngineOptions
        : Optional[zio.aws.fms.model.StatefulEngineOptions.ReadOnly]
    def getStatelessRuleGroups: ZIO[Any, AwsError, List[
      zio.aws.fms.model.StatelessRuleGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("statelessRuleGroups", statelessRuleGroups)
    def getStatelessDefaultActions
        : ZIO[Any, AwsError, List[NetworkFirewallAction]] = AwsError
      .unwrapOptionField("statelessDefaultActions", statelessDefaultActions)
    def getStatelessFragmentDefaultActions
        : ZIO[Any, AwsError, List[NetworkFirewallAction]] =
      AwsError.unwrapOptionField(
        "statelessFragmentDefaultActions",
        statelessFragmentDefaultActions
      )
    def getStatelessCustomActions
        : ZIO[Any, AwsError, List[NetworkFirewallAction]] = AwsError
      .unwrapOptionField("statelessCustomActions", statelessCustomActions)
    def getStatefulRuleGroups: ZIO[Any, AwsError, List[
      zio.aws.fms.model.StatefulRuleGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("statefulRuleGroups", statefulRuleGroups)
    def getStatefulDefaultActions
        : ZIO[Any, AwsError, List[NetworkFirewallAction]] = AwsError
      .unwrapOptionField("statefulDefaultActions", statefulDefaultActions)
    def getStatefulEngineOptions
        : ZIO[Any, AwsError, zio.aws.fms.model.StatefulEngineOptions.ReadOnly] =
      AwsError.unwrapOptionField("statefulEngineOptions", statefulEngineOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallPolicyDescription
  ) extends zio.aws.fms.model.NetworkFirewallPolicyDescription.ReadOnly {
    override val statelessRuleGroups
        : Optional[List[zio.aws.fms.model.StatelessRuleGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statelessRuleGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.StatelessRuleGroup.wrap(item)
          }.toList
        )
    override val statelessDefaultActions
        : Optional[List[NetworkFirewallAction]] = zio.aws.core.internal
      .optionalFromNullable(impl.statelessDefaultActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.primitives.NetworkFirewallAction(item)
        }.toList
      )
    override val statelessFragmentDefaultActions
        : Optional[List[NetworkFirewallAction]] = zio.aws.core.internal
      .optionalFromNullable(impl.statelessFragmentDefaultActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.primitives.NetworkFirewallAction(item)
        }.toList
      )
    override val statelessCustomActions: Optional[List[NetworkFirewallAction]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statelessCustomActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.primitives.NetworkFirewallAction(item)
          }.toList
        )
    override val statefulRuleGroups
        : Optional[List[zio.aws.fms.model.StatefulRuleGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statefulRuleGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.StatefulRuleGroup.wrap(item)
          }.toList
        )
    override val statefulDefaultActions: Optional[List[NetworkFirewallAction]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statefulDefaultActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.primitives.NetworkFirewallAction(item)
          }.toList
        )
    override val statefulEngineOptions
        : Optional[zio.aws.fms.model.StatefulEngineOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statefulEngineOptions())
        .map(value => zio.aws.fms.model.StatefulEngineOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallPolicyDescription
  ): zio.aws.fms.model.NetworkFirewallPolicyDescription.ReadOnly = new Wrapper(
    impl
  )
}
