package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.ResourceId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkFirewallUnexpectedFirewallRoutesViolation(
    firewallSubnetId: Optional[ResourceId] = Optional.Absent,
    violatingRoutes: Optional[Iterable[zio.aws.fms.model.Route]] =
      Optional.Absent,
    routeTableId: Optional[ResourceId] = Optional.Absent,
    firewallEndpoint: Optional[ResourceId] = Optional.Absent,
    vpcId: Optional[ResourceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.NetworkFirewallUnexpectedFirewallRoutesViolation = {
    import NetworkFirewallUnexpectedFirewallRoutesViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.NetworkFirewallUnexpectedFirewallRoutesViolation
      .builder()
      .optionallyWith(
        firewallSubnetId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.firewallSubnetId)
      .optionallyWith(
        violatingRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.violatingRoutes)
      .optionallyWith(
        routeTableId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.routeTableId)
      .optionallyWith(
        firewallEndpoint.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.firewallEndpoint)
      .optionallyWith(
        vpcId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly
      : zio.aws.fms.model.NetworkFirewallUnexpectedFirewallRoutesViolation.ReadOnly =
    zio.aws.fms.model.NetworkFirewallUnexpectedFirewallRoutesViolation
      .wrap(buildAwsValue())
}
object NetworkFirewallUnexpectedFirewallRoutesViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.NetworkFirewallUnexpectedFirewallRoutesViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.fms.model.NetworkFirewallUnexpectedFirewallRoutesViolation =
      zio.aws.fms.model.NetworkFirewallUnexpectedFirewallRoutesViolation(
        firewallSubnetId.map(value => value),
        violatingRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        routeTableId.map(value => value),
        firewallEndpoint.map(value => value),
        vpcId.map(value => value)
      )
    def firewallSubnetId: Optional[ResourceId]
    def violatingRoutes: Optional[List[zio.aws.fms.model.Route.ReadOnly]]
    def routeTableId: Optional[ResourceId]
    def firewallEndpoint: Optional[ResourceId]
    def vpcId: Optional[ResourceId]
    def getFirewallSubnetId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("firewallSubnetId", firewallSubnetId)
    def getViolatingRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.Route.ReadOnly]] =
      AwsError.unwrapOptionField("violatingRoutes", violatingRoutes)
    def getRouteTableId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("routeTableId", routeTableId)
    def getFirewallEndpoint: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("firewallEndpoint", firewallEndpoint)
    def getVpcId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallUnexpectedFirewallRoutesViolation
  ) extends zio.aws.fms.model.NetworkFirewallUnexpectedFirewallRoutesViolation.ReadOnly {
    override val firewallSubnetId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallSubnetId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val violatingRoutes
        : Optional[List[zio.aws.fms.model.Route.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.violatingRoutes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.Route.wrap(item)
          }.toList
        )
    override val routeTableId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.routeTableId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val firewallEndpoint: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallEndpoint())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val vpcId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallUnexpectedFirewallRoutesViolation
  ): zio.aws.fms.model.NetworkFirewallUnexpectedFirewallRoutesViolation.ReadOnly =
    new Wrapper(impl)
}
