package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.ResourceId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkFirewallUnexpectedGatewayRoutesViolation(
    gatewayId: Optional[ResourceId] = Optional.Absent,
    violatingRoutes: Optional[Iterable[zio.aws.fms.model.Route]] =
      Optional.Absent,
    routeTableId: Optional[ResourceId] = Optional.Absent,
    vpcId: Optional[ResourceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation = {
    import NetworkFirewallUnexpectedGatewayRoutesViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation
      .builder()
      .optionallyWith(
        gatewayId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.gatewayId)
      .optionallyWith(
        violatingRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.violatingRoutes)
      .optionallyWith(
        routeTableId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.routeTableId)
      .optionallyWith(
        vpcId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly
      : zio.aws.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation.ReadOnly =
    zio.aws.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation
      .wrap(buildAwsValue())
}
object NetworkFirewallUnexpectedGatewayRoutesViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation =
      zio.aws.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation(
        gatewayId.map(value => value),
        violatingRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        routeTableId.map(value => value),
        vpcId.map(value => value)
      )
    def gatewayId: Optional[ResourceId]
    def violatingRoutes: Optional[List[zio.aws.fms.model.Route.ReadOnly]]
    def routeTableId: Optional[ResourceId]
    def vpcId: Optional[ResourceId]
    def getGatewayId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("gatewayId", gatewayId)
    def getViolatingRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.Route.ReadOnly]] =
      AwsError.unwrapOptionField("violatingRoutes", violatingRoutes)
    def getRouteTableId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("routeTableId", routeTableId)
    def getVpcId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation
  ) extends zio.aws.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation.ReadOnly {
    override val gatewayId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val violatingRoutes
        : Optional[List[zio.aws.fms.model.Route.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.violatingRoutes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.Route.wrap(item)
          }.toList
        )
    override val routeTableId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.routeTableId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val vpcId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation
  ): zio.aws.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation.ReadOnly =
    new Wrapper(impl)
}
