package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{TargetViolationReason, ReferenceRule}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PartialMatch(
    reference: Optional[ReferenceRule] = Optional.Absent,
    targetViolationReasons: Optional[Iterable[TargetViolationReason]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.PartialMatch = {
    import PartialMatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.PartialMatch
      .builder()
      .optionallyWith(
        reference.map(value => ReferenceRule.unwrap(value): java.lang.String)
      )(_.reference)
      .optionallyWith(
        targetViolationReasons.map(value =>
          value.map { item =>
            TargetViolationReason.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targetViolationReasons)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.PartialMatch.ReadOnly =
    zio.aws.fms.model.PartialMatch.wrap(buildAwsValue())
}
object PartialMatch {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fms.model.PartialMatch] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.PartialMatch =
      zio.aws.fms.model.PartialMatch(
        reference.map(value => value),
        targetViolationReasons.map(value => value)
      )
    def reference: Optional[ReferenceRule]
    def targetViolationReasons: Optional[List[TargetViolationReason]]
    def getReference: ZIO[Any, AwsError, ReferenceRule] =
      AwsError.unwrapOptionField("reference", reference)
    def getTargetViolationReasons
        : ZIO[Any, AwsError, List[TargetViolationReason]] = AwsError
      .unwrapOptionField("targetViolationReasons", targetViolationReasons)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.PartialMatch
  ) extends zio.aws.fms.model.PartialMatch.ReadOnly {
    override val reference: Optional[ReferenceRule] = zio.aws.core.internal
      .optionalFromNullable(impl.reference())
      .map(value => zio.aws.fms.model.primitives.ReferenceRule(value))
    override val targetViolationReasons: Optional[List[TargetViolationReason]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetViolationReasons())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.primitives.TargetViolationReason(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.PartialMatch
  ): zio.aws.fms.model.PartialMatch.ReadOnly = new Wrapper(impl)
}
