package zio.aws.fms.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fms.model.primitives.{
  DetailedInfo,
  AWSAccountId,
  TimeStamp,
  PolicyId,
  ResourceName
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class PolicyComplianceStatus(
    policyOwner: Optional[AWSAccountId] = Optional.Absent,
    policyId: Optional[PolicyId] = Optional.Absent,
    policyName: Optional[ResourceName] = Optional.Absent,
    memberAccount: Optional[AWSAccountId] = Optional.Absent,
    evaluationResults: Optional[Iterable[zio.aws.fms.model.EvaluationResult]] =
      Optional.Absent,
    lastUpdated: Optional[TimeStamp] = Optional.Absent,
    issueInfoMap: Optional[
      Map[zio.aws.fms.model.DependentServiceName, DetailedInfo]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.PolicyComplianceStatus = {
    import PolicyComplianceStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.PolicyComplianceStatus
      .builder()
      .optionallyWith(
        policyOwner.map(value => AWSAccountId.unwrap(value): java.lang.String)
      )(_.policyOwner)
      .optionallyWith(
        policyId.map(value => PolicyId.unwrap(value): java.lang.String)
      )(_.policyId)
      .optionallyWith(
        policyName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.policyName)
      .optionallyWith(
        memberAccount.map(value => AWSAccountId.unwrap(value): java.lang.String)
      )(_.memberAccount)
      .optionallyWith(
        evaluationResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.evaluationResults)
      .optionallyWith(
        lastUpdated.map(value => TimeStamp.unwrap(value): Instant)
      )(_.lastUpdated)
      .optionallyWith(
        issueInfoMap.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (DetailedInfo
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.issueInfoMapWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.PolicyComplianceStatus.ReadOnly =
    zio.aws.fms.model.PolicyComplianceStatus.wrap(buildAwsValue())
}
object PolicyComplianceStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.PolicyComplianceStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.PolicyComplianceStatus =
      zio.aws.fms.model.PolicyComplianceStatus(
        policyOwner.map(value => value),
        policyId.map(value => value),
        policyName.map(value => value),
        memberAccount.map(value => value),
        evaluationResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastUpdated.map(value => value),
        issueInfoMap.map(value => value)
      )
    def policyOwner: Optional[AWSAccountId]
    def policyId: Optional[PolicyId]
    def policyName: Optional[ResourceName]
    def memberAccount: Optional[AWSAccountId]
    def evaluationResults
        : Optional[List[zio.aws.fms.model.EvaluationResult.ReadOnly]]
    def lastUpdated: Optional[TimeStamp]
    def issueInfoMap
        : Optional[Map[zio.aws.fms.model.DependentServiceName, DetailedInfo]]
    def getPolicyOwner: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("policyOwner", policyOwner)
    def getPolicyId: ZIO[Any, AwsError, PolicyId] =
      AwsError.unwrapOptionField("policyId", policyId)
    def getPolicyName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("policyName", policyName)
    def getMemberAccount: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("memberAccount", memberAccount)
    def getEvaluationResults: ZIO[Any, AwsError, List[
      zio.aws.fms.model.EvaluationResult.ReadOnly
    ]] = AwsError.unwrapOptionField("evaluationResults", evaluationResults)
    def getLastUpdated: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
    def getIssueInfoMap: ZIO[Any, AwsError, Map[
      zio.aws.fms.model.DependentServiceName,
      DetailedInfo
    ]] = AwsError.unwrapOptionField("issueInfoMap", issueInfoMap)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.PolicyComplianceStatus
  ) extends zio.aws.fms.model.PolicyComplianceStatus.ReadOnly {
    override val policyOwner: Optional[AWSAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.policyOwner())
      .map(value => zio.aws.fms.model.primitives.AWSAccountId(value))
    override val policyId: Optional[PolicyId] = zio.aws.core.internal
      .optionalFromNullable(impl.policyId())
      .map(value => zio.aws.fms.model.primitives.PolicyId(value))
    override val policyName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.policyName())
      .map(value => zio.aws.fms.model.primitives.ResourceName(value))
    override val memberAccount: Optional[AWSAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.memberAccount())
      .map(value => zio.aws.fms.model.primitives.AWSAccountId(value))
    override val evaluationResults
        : Optional[List[zio.aws.fms.model.EvaluationResult.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationResults())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.EvaluationResult.wrap(item)
          }.toList
        )
    override val lastUpdated: Optional[TimeStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdated())
      .map(value => zio.aws.fms.model.primitives.TimeStamp(value))
    override val issueInfoMap
        : Optional[Map[zio.aws.fms.model.DependentServiceName, DetailedInfo]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.issueInfoMap())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.fms.model.DependentServiceName
                .wrap(key) -> zio.aws.fms.model.primitives.DetailedInfo(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.PolicyComplianceStatus
  ): zio.aws.fms.model.PolicyComplianceStatus.ReadOnly = new Wrapper(impl)
}
