package zio.aws.fms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PolicyOption(
    networkFirewallPolicy: Optional[zio.aws.fms.model.NetworkFirewallPolicy] =
      Optional.Absent,
    thirdPartyFirewallPolicy: Optional[
      zio.aws.fms.model.ThirdPartyFirewallPolicy
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.PolicyOption = {
    import PolicyOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.PolicyOption
      .builder()
      .optionallyWith(
        networkFirewallPolicy.map(value => value.buildAwsValue())
      )(_.networkFirewallPolicy)
      .optionallyWith(
        thirdPartyFirewallPolicy.map(value => value.buildAwsValue())
      )(_.thirdPartyFirewallPolicy)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.PolicyOption.ReadOnly =
    zio.aws.fms.model.PolicyOption.wrap(buildAwsValue())
}
object PolicyOption {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fms.model.PolicyOption] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.PolicyOption =
      zio.aws.fms.model.PolicyOption(
        networkFirewallPolicy.map(value => value.asEditable),
        thirdPartyFirewallPolicy.map(value => value.asEditable)
      )
    def networkFirewallPolicy
        : Optional[zio.aws.fms.model.NetworkFirewallPolicy.ReadOnly]
    def thirdPartyFirewallPolicy
        : Optional[zio.aws.fms.model.ThirdPartyFirewallPolicy.ReadOnly]
    def getNetworkFirewallPolicy
        : ZIO[Any, AwsError, zio.aws.fms.model.NetworkFirewallPolicy.ReadOnly] =
      AwsError.unwrapOptionField("networkFirewallPolicy", networkFirewallPolicy)
    def getThirdPartyFirewallPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.ThirdPartyFirewallPolicy.ReadOnly
    ] = AwsError.unwrapOptionField(
      "thirdPartyFirewallPolicy",
      thirdPartyFirewallPolicy
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.PolicyOption
  ) extends zio.aws.fms.model.PolicyOption.ReadOnly {
    override val networkFirewallPolicy
        : Optional[zio.aws.fms.model.NetworkFirewallPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkFirewallPolicy())
        .map(value => zio.aws.fms.model.NetworkFirewallPolicy.wrap(value))
    override val thirdPartyFirewallPolicy
        : Optional[zio.aws.fms.model.ThirdPartyFirewallPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thirdPartyFirewallPolicy())
        .map(value => zio.aws.fms.model.ThirdPartyFirewallPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.PolicyOption
  ): zio.aws.fms.model.PolicyOption.ReadOnly = new Wrapper(impl)
}
