package zio.aws.fms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutAppsListRequest(
    appsList: zio.aws.fms.model.AppsListData,
    tagList: Optional[Iterable[zio.aws.fms.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.PutAppsListRequest = {
    import PutAppsListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.PutAppsListRequest
      .builder()
      .appsList(appsList.buildAwsValue())
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.PutAppsListRequest.ReadOnly =
    zio.aws.fms.model.PutAppsListRequest.wrap(buildAwsValue())
}
object PutAppsListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.PutAppsListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.PutAppsListRequest =
      zio.aws.fms.model.PutAppsListRequest(
        appsList.asEditable,
        tagList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def appsList: zio.aws.fms.model.AppsListData.ReadOnly
    def tagList: Optional[List[zio.aws.fms.model.Tag.ReadOnly]]
    def getAppsList
        : ZIO[Any, Nothing, zio.aws.fms.model.AppsListData.ReadOnly] =
      ZIO.succeed(appsList)
    def getTagList: ZIO[Any, AwsError, List[zio.aws.fms.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.PutAppsListRequest
  ) extends zio.aws.fms.model.PutAppsListRequest.ReadOnly {
    override val appsList: zio.aws.fms.model.AppsListData.ReadOnly =
      zio.aws.fms.model.AppsListData.wrap(impl.appsList())
    override val tagList: Optional[List[zio.aws.fms.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.PutAppsListRequest
  ): zio.aws.fms.model.PutAppsListRequest.ReadOnly = new Wrapper(impl)
}
