package zio.aws.fms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutPolicyRequest(
    policy: zio.aws.fms.model.Policy,
    tagList: Optional[Iterable[zio.aws.fms.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.PutPolicyRequest = {
    import PutPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.PutPolicyRequest
      .builder()
      .policy(policy.buildAwsValue())
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.PutPolicyRequest.ReadOnly =
    zio.aws.fms.model.PutPolicyRequest.wrap(buildAwsValue())
}
object PutPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.PutPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.PutPolicyRequest =
      zio.aws.fms.model.PutPolicyRequest(
        policy.asEditable,
        tagList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def policy: zio.aws.fms.model.Policy.ReadOnly
    def tagList: Optional[List[zio.aws.fms.model.Tag.ReadOnly]]
    def getPolicy: ZIO[Any, Nothing, zio.aws.fms.model.Policy.ReadOnly] =
      ZIO.succeed(policy)
    def getTagList: ZIO[Any, AwsError, List[zio.aws.fms.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.PutPolicyRequest
  ) extends zio.aws.fms.model.PutPolicyRequest.ReadOnly {
    override val policy: zio.aws.fms.model.Policy.ReadOnly =
      zio.aws.fms.model.Policy.wrap(impl.policy())
    override val tagList: Optional[List[zio.aws.fms.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.PutPolicyRequest
  ): zio.aws.fms.model.PutPolicyRequest.ReadOnly = new Wrapper(impl)
}
