package zio.aws.fms.model
import scala.jdk.CollectionConverters._
sealed trait RemediationActionType {
  def unwrap: software.amazon.awssdk.services.fms.model.RemediationActionType
}
object RemediationActionType {
  def wrap(
      value: software.amazon.awssdk.services.fms.model.RemediationActionType
  ): zio.aws.fms.model.RemediationActionType = value match {
    case software.amazon.awssdk.services.fms.model.RemediationActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fms.model.RemediationActionType.REMOVE =>
      val r = REMOVE
      r
    case software.amazon.awssdk.services.fms.model.RemediationActionType.MODIFY =>
      val r = MODIFY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.fms.model.RemediationActionType {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.RemediationActionType =
      software.amazon.awssdk.services.fms.model.RemediationActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object REMOVE extends zio.aws.fms.model.RemediationActionType {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.RemediationActionType =
      software.amazon.awssdk.services.fms.model.RemediationActionType.REMOVE
  }
  case object MODIFY extends zio.aws.fms.model.RemediationActionType {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.RemediationActionType =
      software.amazon.awssdk.services.fms.model.RemediationActionType.MODIFY
  }
}
