package zio.aws.fms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResourceViolation(
    awsVPCSecurityGroupViolation: Optional[
      zio.aws.fms.model.AwsVPCSecurityGroupViolation
    ] = Optional.Absent,
    awsEc2NetworkInterfaceViolation: Optional[
      zio.aws.fms.model.AwsEc2NetworkInterfaceViolation
    ] = Optional.Absent,
    awsEc2InstanceViolation: Optional[
      zio.aws.fms.model.AwsEc2InstanceViolation
    ] = Optional.Absent,
    networkFirewallMissingFirewallViolation: Optional[
      zio.aws.fms.model.NetworkFirewallMissingFirewallViolation
    ] = Optional.Absent,
    networkFirewallMissingSubnetViolation: Optional[
      zio.aws.fms.model.NetworkFirewallMissingSubnetViolation
    ] = Optional.Absent,
    networkFirewallMissingExpectedRTViolation: Optional[
      zio.aws.fms.model.NetworkFirewallMissingExpectedRTViolation
    ] = Optional.Absent,
    networkFirewallPolicyModifiedViolation: Optional[
      zio.aws.fms.model.NetworkFirewallPolicyModifiedViolation
    ] = Optional.Absent,
    networkFirewallInternetTrafficNotInspectedViolation: Optional[
      zio.aws.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation
    ] = Optional.Absent,
    networkFirewallInvalidRouteConfigurationViolation: Optional[
      zio.aws.fms.model.NetworkFirewallInvalidRouteConfigurationViolation
    ] = Optional.Absent,
    networkFirewallBlackHoleRouteDetectedViolation: Optional[
      zio.aws.fms.model.NetworkFirewallBlackHoleRouteDetectedViolation
    ] = Optional.Absent,
    networkFirewallUnexpectedFirewallRoutesViolation: Optional[
      zio.aws.fms.model.NetworkFirewallUnexpectedFirewallRoutesViolation
    ] = Optional.Absent,
    networkFirewallUnexpectedGatewayRoutesViolation: Optional[
      zio.aws.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation
    ] = Optional.Absent,
    networkFirewallMissingExpectedRoutesViolation: Optional[
      zio.aws.fms.model.NetworkFirewallMissingExpectedRoutesViolation
    ] = Optional.Absent,
    dnsRuleGroupPriorityConflictViolation: Optional[
      zio.aws.fms.model.DnsRuleGroupPriorityConflictViolation
    ] = Optional.Absent,
    dnsDuplicateRuleGroupViolation: Optional[
      zio.aws.fms.model.DnsDuplicateRuleGroupViolation
    ] = Optional.Absent,
    dnsRuleGroupLimitExceededViolation: Optional[
      zio.aws.fms.model.DnsRuleGroupLimitExceededViolation
    ] = Optional.Absent,
    possibleRemediationActions: Optional[
      zio.aws.fms.model.PossibleRemediationActions
    ] = Optional.Absent,
    firewallSubnetIsOutOfScopeViolation: Optional[
      zio.aws.fms.model.FirewallSubnetIsOutOfScopeViolation
    ] = Optional.Absent,
    routeHasOutOfScopeEndpointViolation: Optional[
      zio.aws.fms.model.RouteHasOutOfScopeEndpointViolation
    ] = Optional.Absent,
    thirdPartyFirewallMissingFirewallViolation: Optional[
      zio.aws.fms.model.ThirdPartyFirewallMissingFirewallViolation
    ] = Optional.Absent,
    thirdPartyFirewallMissingSubnetViolation: Optional[
      zio.aws.fms.model.ThirdPartyFirewallMissingSubnetViolation
    ] = Optional.Absent,
    thirdPartyFirewallMissingExpectedRouteTableViolation: Optional[
      zio.aws.fms.model.ThirdPartyFirewallMissingExpectedRouteTableViolation
    ] = Optional.Absent,
    firewallSubnetMissingVPCEndpointViolation: Optional[
      zio.aws.fms.model.FirewallSubnetMissingVPCEndpointViolation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ResourceViolation = {
    import ResourceViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ResourceViolation
      .builder()
      .optionallyWith(
        awsVPCSecurityGroupViolation.map(value => value.buildAwsValue())
      )(_.awsVPCSecurityGroupViolation)
      .optionallyWith(
        awsEc2NetworkInterfaceViolation.map(value => value.buildAwsValue())
      )(_.awsEc2NetworkInterfaceViolation)
      .optionallyWith(
        awsEc2InstanceViolation.map(value => value.buildAwsValue())
      )(_.awsEc2InstanceViolation)
      .optionallyWith(
        networkFirewallMissingFirewallViolation.map(value =>
          value.buildAwsValue()
        )
      )(_.networkFirewallMissingFirewallViolation)
      .optionallyWith(
        networkFirewallMissingSubnetViolation.map(value =>
          value.buildAwsValue()
        )
      )(_.networkFirewallMissingSubnetViolation)
      .optionallyWith(
        networkFirewallMissingExpectedRTViolation.map(value =>
          value.buildAwsValue()
        )
      )(_.networkFirewallMissingExpectedRTViolation)
      .optionallyWith(
        networkFirewallPolicyModifiedViolation.map(value =>
          value.buildAwsValue()
        )
      )(_.networkFirewallPolicyModifiedViolation)
      .optionallyWith(
        networkFirewallInternetTrafficNotInspectedViolation.map(value =>
          value.buildAwsValue()
        )
      )(_.networkFirewallInternetTrafficNotInspectedViolation)
      .optionallyWith(
        networkFirewallInvalidRouteConfigurationViolation.map(value =>
          value.buildAwsValue()
        )
      )(_.networkFirewallInvalidRouteConfigurationViolation)
      .optionallyWith(
        networkFirewallBlackHoleRouteDetectedViolation.map(value =>
          value.buildAwsValue()
        )
      )(_.networkFirewallBlackHoleRouteDetectedViolation)
      .optionallyWith(
        networkFirewallUnexpectedFirewallRoutesViolation.map(value =>
          value.buildAwsValue()
        )
      )(_.networkFirewallUnexpectedFirewallRoutesViolation)
      .optionallyWith(
        networkFirewallUnexpectedGatewayRoutesViolation.map(value =>
          value.buildAwsValue()
        )
      )(_.networkFirewallUnexpectedGatewayRoutesViolation)
      .optionallyWith(
        networkFirewallMissingExpectedRoutesViolation.map(value =>
          value.buildAwsValue()
        )
      )(_.networkFirewallMissingExpectedRoutesViolation)
      .optionallyWith(
        dnsRuleGroupPriorityConflictViolation.map(value =>
          value.buildAwsValue()
        )
      )(_.dnsRuleGroupPriorityConflictViolation)
      .optionallyWith(
        dnsDuplicateRuleGroupViolation.map(value => value.buildAwsValue())
      )(_.dnsDuplicateRuleGroupViolation)
      .optionallyWith(
        dnsRuleGroupLimitExceededViolation.map(value => value.buildAwsValue())
      )(_.dnsRuleGroupLimitExceededViolation)
      .optionallyWith(
        possibleRemediationActions.map(value => value.buildAwsValue())
      )(_.possibleRemediationActions)
      .optionallyWith(
        firewallSubnetIsOutOfScopeViolation.map(value => value.buildAwsValue())
      )(_.firewallSubnetIsOutOfScopeViolation)
      .optionallyWith(
        routeHasOutOfScopeEndpointViolation.map(value => value.buildAwsValue())
      )(_.routeHasOutOfScopeEndpointViolation)
      .optionallyWith(
        thirdPartyFirewallMissingFirewallViolation.map(value =>
          value.buildAwsValue()
        )
      )(_.thirdPartyFirewallMissingFirewallViolation)
      .optionallyWith(
        thirdPartyFirewallMissingSubnetViolation.map(value =>
          value.buildAwsValue()
        )
      )(_.thirdPartyFirewallMissingSubnetViolation)
      .optionallyWith(
        thirdPartyFirewallMissingExpectedRouteTableViolation.map(value =>
          value.buildAwsValue()
        )
      )(_.thirdPartyFirewallMissingExpectedRouteTableViolation)
      .optionallyWith(
        firewallSubnetMissingVPCEndpointViolation.map(value =>
          value.buildAwsValue()
        )
      )(_.firewallSubnetMissingVPCEndpointViolation)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.ResourceViolation.ReadOnly =
    zio.aws.fms.model.ResourceViolation.wrap(buildAwsValue())
}
object ResourceViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.ResourceViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.ResourceViolation =
      zio.aws.fms.model.ResourceViolation(
        awsVPCSecurityGroupViolation.map(value => value.asEditable),
        awsEc2NetworkInterfaceViolation.map(value => value.asEditable),
        awsEc2InstanceViolation.map(value => value.asEditable),
        networkFirewallMissingFirewallViolation.map(value => value.asEditable),
        networkFirewallMissingSubnetViolation.map(value => value.asEditable),
        networkFirewallMissingExpectedRTViolation.map(value =>
          value.asEditable
        ),
        networkFirewallPolicyModifiedViolation.map(value => value.asEditable),
        networkFirewallInternetTrafficNotInspectedViolation.map(value =>
          value.asEditable
        ),
        networkFirewallInvalidRouteConfigurationViolation.map(value =>
          value.asEditable
        ),
        networkFirewallBlackHoleRouteDetectedViolation.map(value =>
          value.asEditable
        ),
        networkFirewallUnexpectedFirewallRoutesViolation.map(value =>
          value.asEditable
        ),
        networkFirewallUnexpectedGatewayRoutesViolation.map(value =>
          value.asEditable
        ),
        networkFirewallMissingExpectedRoutesViolation.map(value =>
          value.asEditable
        ),
        dnsRuleGroupPriorityConflictViolation.map(value => value.asEditable),
        dnsDuplicateRuleGroupViolation.map(value => value.asEditable),
        dnsRuleGroupLimitExceededViolation.map(value => value.asEditable),
        possibleRemediationActions.map(value => value.asEditable),
        firewallSubnetIsOutOfScopeViolation.map(value => value.asEditable),
        routeHasOutOfScopeEndpointViolation.map(value => value.asEditable),
        thirdPartyFirewallMissingFirewallViolation.map(value =>
          value.asEditable
        ),
        thirdPartyFirewallMissingSubnetViolation.map(value => value.asEditable),
        thirdPartyFirewallMissingExpectedRouteTableViolation.map(value =>
          value.asEditable
        ),
        firewallSubnetMissingVPCEndpointViolation.map(value => value.asEditable)
      )
    def awsVPCSecurityGroupViolation
        : Optional[zio.aws.fms.model.AwsVPCSecurityGroupViolation.ReadOnly]
    def awsEc2NetworkInterfaceViolation
        : Optional[zio.aws.fms.model.AwsEc2NetworkInterfaceViolation.ReadOnly]
    def awsEc2InstanceViolation
        : Optional[zio.aws.fms.model.AwsEc2InstanceViolation.ReadOnly]
    def networkFirewallMissingFirewallViolation: Optional[
      zio.aws.fms.model.NetworkFirewallMissingFirewallViolation.ReadOnly
    ]
    def networkFirewallMissingSubnetViolation: Optional[
      zio.aws.fms.model.NetworkFirewallMissingSubnetViolation.ReadOnly
    ]
    def networkFirewallMissingExpectedRTViolation: Optional[
      zio.aws.fms.model.NetworkFirewallMissingExpectedRTViolation.ReadOnly
    ]
    def networkFirewallPolicyModifiedViolation: Optional[
      zio.aws.fms.model.NetworkFirewallPolicyModifiedViolation.ReadOnly
    ]
    def networkFirewallInternetTrafficNotInspectedViolation: Optional[
      zio.aws.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation.ReadOnly
    ]
    def networkFirewallInvalidRouteConfigurationViolation: Optional[
      zio.aws.fms.model.NetworkFirewallInvalidRouteConfigurationViolation.ReadOnly
    ]
    def networkFirewallBlackHoleRouteDetectedViolation: Optional[
      zio.aws.fms.model.NetworkFirewallBlackHoleRouteDetectedViolation.ReadOnly
    ]
    def networkFirewallUnexpectedFirewallRoutesViolation: Optional[
      zio.aws.fms.model.NetworkFirewallUnexpectedFirewallRoutesViolation.ReadOnly
    ]
    def networkFirewallUnexpectedGatewayRoutesViolation: Optional[
      zio.aws.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation.ReadOnly
    ]
    def networkFirewallMissingExpectedRoutesViolation: Optional[
      zio.aws.fms.model.NetworkFirewallMissingExpectedRoutesViolation.ReadOnly
    ]
    def dnsRuleGroupPriorityConflictViolation: Optional[
      zio.aws.fms.model.DnsRuleGroupPriorityConflictViolation.ReadOnly
    ]
    def dnsDuplicateRuleGroupViolation
        : Optional[zio.aws.fms.model.DnsDuplicateRuleGroupViolation.ReadOnly]
    def dnsRuleGroupLimitExceededViolation: Optional[
      zio.aws.fms.model.DnsRuleGroupLimitExceededViolation.ReadOnly
    ]
    def possibleRemediationActions
        : Optional[zio.aws.fms.model.PossibleRemediationActions.ReadOnly]
    def firewallSubnetIsOutOfScopeViolation: Optional[
      zio.aws.fms.model.FirewallSubnetIsOutOfScopeViolation.ReadOnly
    ]
    def routeHasOutOfScopeEndpointViolation: Optional[
      zio.aws.fms.model.RouteHasOutOfScopeEndpointViolation.ReadOnly
    ]
    def thirdPartyFirewallMissingFirewallViolation: Optional[
      zio.aws.fms.model.ThirdPartyFirewallMissingFirewallViolation.ReadOnly
    ]
    def thirdPartyFirewallMissingSubnetViolation: Optional[
      zio.aws.fms.model.ThirdPartyFirewallMissingSubnetViolation.ReadOnly
    ]
    def thirdPartyFirewallMissingExpectedRouteTableViolation: Optional[
      zio.aws.fms.model.ThirdPartyFirewallMissingExpectedRouteTableViolation.ReadOnly
    ]
    def firewallSubnetMissingVPCEndpointViolation: Optional[
      zio.aws.fms.model.FirewallSubnetMissingVPCEndpointViolation.ReadOnly
    ]
    def getAwsVPCSecurityGroupViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.AwsVPCSecurityGroupViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsVPCSecurityGroupViolation",
      awsVPCSecurityGroupViolation
    )
    def getAwsEc2NetworkInterfaceViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.AwsEc2NetworkInterfaceViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsEc2NetworkInterfaceViolation",
      awsEc2NetworkInterfaceViolation
    )
    def getAwsEc2InstanceViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.AwsEc2InstanceViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsEc2InstanceViolation",
      awsEc2InstanceViolation
    )
    def getNetworkFirewallMissingFirewallViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.NetworkFirewallMissingFirewallViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkFirewallMissingFirewallViolation",
      networkFirewallMissingFirewallViolation
    )
    def getNetworkFirewallMissingSubnetViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.NetworkFirewallMissingSubnetViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkFirewallMissingSubnetViolation",
      networkFirewallMissingSubnetViolation
    )
    def getNetworkFirewallMissingExpectedRTViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.NetworkFirewallMissingExpectedRTViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkFirewallMissingExpectedRTViolation",
      networkFirewallMissingExpectedRTViolation
    )
    def getNetworkFirewallPolicyModifiedViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.NetworkFirewallPolicyModifiedViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkFirewallPolicyModifiedViolation",
      networkFirewallPolicyModifiedViolation
    )
    def getNetworkFirewallInternetTrafficNotInspectedViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkFirewallInternetTrafficNotInspectedViolation",
      networkFirewallInternetTrafficNotInspectedViolation
    )
    def getNetworkFirewallInvalidRouteConfigurationViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.NetworkFirewallInvalidRouteConfigurationViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkFirewallInvalidRouteConfigurationViolation",
      networkFirewallInvalidRouteConfigurationViolation
    )
    def getNetworkFirewallBlackHoleRouteDetectedViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.NetworkFirewallBlackHoleRouteDetectedViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkFirewallBlackHoleRouteDetectedViolation",
      networkFirewallBlackHoleRouteDetectedViolation
    )
    def getNetworkFirewallUnexpectedFirewallRoutesViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.NetworkFirewallUnexpectedFirewallRoutesViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkFirewallUnexpectedFirewallRoutesViolation",
      networkFirewallUnexpectedFirewallRoutesViolation
    )
    def getNetworkFirewallUnexpectedGatewayRoutesViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkFirewallUnexpectedGatewayRoutesViolation",
      networkFirewallUnexpectedGatewayRoutesViolation
    )
    def getNetworkFirewallMissingExpectedRoutesViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.NetworkFirewallMissingExpectedRoutesViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkFirewallMissingExpectedRoutesViolation",
      networkFirewallMissingExpectedRoutesViolation
    )
    def getDnsRuleGroupPriorityConflictViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.DnsRuleGroupPriorityConflictViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dnsRuleGroupPriorityConflictViolation",
      dnsRuleGroupPriorityConflictViolation
    )
    def getDnsDuplicateRuleGroupViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.DnsDuplicateRuleGroupViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dnsDuplicateRuleGroupViolation",
      dnsDuplicateRuleGroupViolation
    )
    def getDnsRuleGroupLimitExceededViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.DnsRuleGroupLimitExceededViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dnsRuleGroupLimitExceededViolation",
      dnsRuleGroupLimitExceededViolation
    )
    def getPossibleRemediationActions: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.PossibleRemediationActions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "possibleRemediationActions",
      possibleRemediationActions
    )
    def getFirewallSubnetIsOutOfScopeViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.FirewallSubnetIsOutOfScopeViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "firewallSubnetIsOutOfScopeViolation",
      firewallSubnetIsOutOfScopeViolation
    )
    def getRouteHasOutOfScopeEndpointViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.RouteHasOutOfScopeEndpointViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "routeHasOutOfScopeEndpointViolation",
      routeHasOutOfScopeEndpointViolation
    )
    def getThirdPartyFirewallMissingFirewallViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.ThirdPartyFirewallMissingFirewallViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "thirdPartyFirewallMissingFirewallViolation",
      thirdPartyFirewallMissingFirewallViolation
    )
    def getThirdPartyFirewallMissingSubnetViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.ThirdPartyFirewallMissingSubnetViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "thirdPartyFirewallMissingSubnetViolation",
      thirdPartyFirewallMissingSubnetViolation
    )
    def getThirdPartyFirewallMissingExpectedRouteTableViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.ThirdPartyFirewallMissingExpectedRouteTableViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "thirdPartyFirewallMissingExpectedRouteTableViolation",
      thirdPartyFirewallMissingExpectedRouteTableViolation
    )
    def getFirewallSubnetMissingVPCEndpointViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.FirewallSubnetMissingVPCEndpointViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "firewallSubnetMissingVPCEndpointViolation",
      firewallSubnetMissingVPCEndpointViolation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ResourceViolation
  ) extends zio.aws.fms.model.ResourceViolation.ReadOnly {
    override val awsVPCSecurityGroupViolation
        : Optional[zio.aws.fms.model.AwsVPCSecurityGroupViolation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsVPCSecurityGroupViolation())
        .map(value =>
          zio.aws.fms.model.AwsVPCSecurityGroupViolation.wrap(value)
        )
    override val awsEc2NetworkInterfaceViolation
        : Optional[zio.aws.fms.model.AwsEc2NetworkInterfaceViolation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsEc2NetworkInterfaceViolation())
        .map(value =>
          zio.aws.fms.model.AwsEc2NetworkInterfaceViolation.wrap(value)
        )
    override val awsEc2InstanceViolation
        : Optional[zio.aws.fms.model.AwsEc2InstanceViolation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsEc2InstanceViolation())
        .map(value => zio.aws.fms.model.AwsEc2InstanceViolation.wrap(value))
    override val networkFirewallMissingFirewallViolation: Optional[
      zio.aws.fms.model.NetworkFirewallMissingFirewallViolation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.networkFirewallMissingFirewallViolation())
      .map(value =>
        zio.aws.fms.model.NetworkFirewallMissingFirewallViolation.wrap(value)
      )
    override val networkFirewallMissingSubnetViolation: Optional[
      zio.aws.fms.model.NetworkFirewallMissingSubnetViolation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.networkFirewallMissingSubnetViolation())
      .map(value =>
        zio.aws.fms.model.NetworkFirewallMissingSubnetViolation.wrap(value)
      )
    override val networkFirewallMissingExpectedRTViolation: Optional[
      zio.aws.fms.model.NetworkFirewallMissingExpectedRTViolation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.networkFirewallMissingExpectedRTViolation())
      .map(value =>
        zio.aws.fms.model.NetworkFirewallMissingExpectedRTViolation.wrap(value)
      )
    override val networkFirewallPolicyModifiedViolation: Optional[
      zio.aws.fms.model.NetworkFirewallPolicyModifiedViolation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.networkFirewallPolicyModifiedViolation())
      .map(value =>
        zio.aws.fms.model.NetworkFirewallPolicyModifiedViolation.wrap(value)
      )
    override val networkFirewallInternetTrafficNotInspectedViolation: Optional[
      zio.aws.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.networkFirewallInternetTrafficNotInspectedViolation()
      )
      .map(value =>
        zio.aws.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation
          .wrap(value)
      )
    override val networkFirewallInvalidRouteConfigurationViolation: Optional[
      zio.aws.fms.model.NetworkFirewallInvalidRouteConfigurationViolation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.networkFirewallInvalidRouteConfigurationViolation()
      )
      .map(value =>
        zio.aws.fms.model.NetworkFirewallInvalidRouteConfigurationViolation
          .wrap(value)
      )
    override val networkFirewallBlackHoleRouteDetectedViolation: Optional[
      zio.aws.fms.model.NetworkFirewallBlackHoleRouteDetectedViolation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.networkFirewallBlackHoleRouteDetectedViolation()
      )
      .map(value =>
        zio.aws.fms.model.NetworkFirewallBlackHoleRouteDetectedViolation
          .wrap(value)
      )
    override val networkFirewallUnexpectedFirewallRoutesViolation: Optional[
      zio.aws.fms.model.NetworkFirewallUnexpectedFirewallRoutesViolation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.networkFirewallUnexpectedFirewallRoutesViolation()
      )
      .map(value =>
        zio.aws.fms.model.NetworkFirewallUnexpectedFirewallRoutesViolation
          .wrap(value)
      )
    override val networkFirewallUnexpectedGatewayRoutesViolation: Optional[
      zio.aws.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.networkFirewallUnexpectedGatewayRoutesViolation()
      )
      .map(value =>
        zio.aws.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation
          .wrap(value)
      )
    override val networkFirewallMissingExpectedRoutesViolation: Optional[
      zio.aws.fms.model.NetworkFirewallMissingExpectedRoutesViolation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.networkFirewallMissingExpectedRoutesViolation()
      )
      .map(value =>
        zio.aws.fms.model.NetworkFirewallMissingExpectedRoutesViolation
          .wrap(value)
      )
    override val dnsRuleGroupPriorityConflictViolation: Optional[
      zio.aws.fms.model.DnsRuleGroupPriorityConflictViolation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsRuleGroupPriorityConflictViolation())
      .map(value =>
        zio.aws.fms.model.DnsRuleGroupPriorityConflictViolation.wrap(value)
      )
    override val dnsDuplicateRuleGroupViolation
        : Optional[zio.aws.fms.model.DnsDuplicateRuleGroupViolation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnsDuplicateRuleGroupViolation())
        .map(value =>
          zio.aws.fms.model.DnsDuplicateRuleGroupViolation.wrap(value)
        )
    override val dnsRuleGroupLimitExceededViolation: Optional[
      zio.aws.fms.model.DnsRuleGroupLimitExceededViolation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsRuleGroupLimitExceededViolation())
      .map(value =>
        zio.aws.fms.model.DnsRuleGroupLimitExceededViolation.wrap(value)
      )
    override val possibleRemediationActions
        : Optional[zio.aws.fms.model.PossibleRemediationActions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.possibleRemediationActions())
        .map(value => zio.aws.fms.model.PossibleRemediationActions.wrap(value))
    override val firewallSubnetIsOutOfScopeViolation: Optional[
      zio.aws.fms.model.FirewallSubnetIsOutOfScopeViolation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallSubnetIsOutOfScopeViolation())
      .map(value =>
        zio.aws.fms.model.FirewallSubnetIsOutOfScopeViolation.wrap(value)
      )
    override val routeHasOutOfScopeEndpointViolation: Optional[
      zio.aws.fms.model.RouteHasOutOfScopeEndpointViolation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.routeHasOutOfScopeEndpointViolation())
      .map(value =>
        zio.aws.fms.model.RouteHasOutOfScopeEndpointViolation.wrap(value)
      )
    override val thirdPartyFirewallMissingFirewallViolation: Optional[
      zio.aws.fms.model.ThirdPartyFirewallMissingFirewallViolation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.thirdPartyFirewallMissingFirewallViolation())
      .map(value =>
        zio.aws.fms.model.ThirdPartyFirewallMissingFirewallViolation.wrap(value)
      )
    override val thirdPartyFirewallMissingSubnetViolation: Optional[
      zio.aws.fms.model.ThirdPartyFirewallMissingSubnetViolation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.thirdPartyFirewallMissingSubnetViolation())
      .map(value =>
        zio.aws.fms.model.ThirdPartyFirewallMissingSubnetViolation.wrap(value)
      )
    override val thirdPartyFirewallMissingExpectedRouteTableViolation: Optional[
      zio.aws.fms.model.ThirdPartyFirewallMissingExpectedRouteTableViolation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.thirdPartyFirewallMissingExpectedRouteTableViolation()
      )
      .map(value =>
        zio.aws.fms.model.ThirdPartyFirewallMissingExpectedRouteTableViolation
          .wrap(value)
      )
    override val firewallSubnetMissingVPCEndpointViolation: Optional[
      zio.aws.fms.model.FirewallSubnetMissingVPCEndpointViolation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallSubnetMissingVPCEndpointViolation())
      .map(value =>
        zio.aws.fms.model.FirewallSubnetMissingVPCEndpointViolation.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ResourceViolation
  ): zio.aws.fms.model.ResourceViolation.ReadOnly = new Wrapper(impl)
}
