package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.LengthBoundedString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Route(
    destinationType: Optional[zio.aws.fms.model.DestinationType] =
      Optional.Absent,
    targetType: Optional[zio.aws.fms.model.TargetType] = Optional.Absent,
    destination: Optional[LengthBoundedString] = Optional.Absent,
    target: Optional[LengthBoundedString] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.fms.model.Route = {
    import Route.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.Route
      .builder()
      .optionallyWith(destinationType.map(value => value.unwrap))(
        _.destinationType
      )
      .optionallyWith(targetType.map(value => value.unwrap))(_.targetType)
      .optionallyWith(
        destination.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.destination)
      .optionallyWith(
        target.map(value => LengthBoundedString.unwrap(value): java.lang.String)
      )(_.target)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.Route.ReadOnly =
    zio.aws.fms.model.Route.wrap(buildAwsValue())
}
object Route {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fms.model.Route] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.Route = zio.aws.fms.model.Route(
      destinationType.map(value => value),
      targetType.map(value => value),
      destination.map(value => value),
      target.map(value => value)
    )
    def destinationType: Optional[zio.aws.fms.model.DestinationType]
    def targetType: Optional[zio.aws.fms.model.TargetType]
    def destination: Optional[LengthBoundedString]
    def target: Optional[LengthBoundedString]
    def getDestinationType
        : ZIO[Any, AwsError, zio.aws.fms.model.DestinationType] =
      AwsError.unwrapOptionField("destinationType", destinationType)
    def getTargetType: ZIO[Any, AwsError, zio.aws.fms.model.TargetType] =
      AwsError.unwrapOptionField("targetType", targetType)
    def getDestination: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField("destination", destination)
    def getTarget: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField("target", target)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.Route
  ) extends zio.aws.fms.model.Route.ReadOnly {
    override val destinationType: Optional[zio.aws.fms.model.DestinationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationType())
        .map(value => zio.aws.fms.model.DestinationType.wrap(value))
    override val targetType: Optional[zio.aws.fms.model.TargetType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetType())
        .map(value => zio.aws.fms.model.TargetType.wrap(value))
    override val destination: Optional[LengthBoundedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destination())
        .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val target: Optional[LengthBoundedString] = zio.aws.core.internal
      .optionalFromNullable(impl.target())
      .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.Route
  ): zio.aws.fms.model.Route.ReadOnly = new Wrapper(impl)
}
