package zio.aws.fms.model
import scala.jdk.CollectionConverters._
sealed trait SecurityServiceType {
  def unwrap: software.amazon.awssdk.services.fms.model.SecurityServiceType
}
object SecurityServiceType {
  def wrap(
      value: software.amazon.awssdk.services.fms.model.SecurityServiceType
  ): zio.aws.fms.model.SecurityServiceType = value match {
    case software.amazon.awssdk.services.fms.model.SecurityServiceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fms.model.SecurityServiceType.WAF =>
      val r = WAF
      r
    case software.amazon.awssdk.services.fms.model.SecurityServiceType.WAFV2 =>
      val r = WAFV2
      r
    case software.amazon.awssdk.services.fms.model.SecurityServiceType.SHIELD_ADVANCED =>
      val r = SHIELD_ADVANCED
      r
    case software.amazon.awssdk.services.fms.model.SecurityServiceType.SECURITY_GROUPS_COMMON =>
      val r = SECURITY_GROUPS_COMMON
      r
    case software.amazon.awssdk.services.fms.model.SecurityServiceType.SECURITY_GROUPS_CONTENT_AUDIT =>
      val r = SECURITY_GROUPS_CONTENT_AUDIT
      r
    case software.amazon.awssdk.services.fms.model.SecurityServiceType.SECURITY_GROUPS_USAGE_AUDIT =>
      val r = SECURITY_GROUPS_USAGE_AUDIT
      r
    case software.amazon.awssdk.services.fms.model.SecurityServiceType.NETWORK_FIREWALL =>
      val r = NETWORK_FIREWALL
      r
    case software.amazon.awssdk.services.fms.model.SecurityServiceType.DNS_FIREWALL =>
      val r = DNS_FIREWALL
      r
    case software.amazon.awssdk.services.fms.model.SecurityServiceType.THIRD_PARTY_FIREWALL =>
      val r = THIRD_PARTY_FIREWALL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.fms.model.SecurityServiceType {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.SecurityServiceType =
      software.amazon.awssdk.services.fms.model.SecurityServiceType.UNKNOWN_TO_SDK_VERSION
  }
  case object WAF extends zio.aws.fms.model.SecurityServiceType {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.SecurityServiceType =
      software.amazon.awssdk.services.fms.model.SecurityServiceType.WAF
  }
  case object WAFV2 extends zio.aws.fms.model.SecurityServiceType {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.SecurityServiceType =
      software.amazon.awssdk.services.fms.model.SecurityServiceType.WAFV2
  }
  case object SHIELD_ADVANCED extends zio.aws.fms.model.SecurityServiceType {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.SecurityServiceType =
      software.amazon.awssdk.services.fms.model.SecurityServiceType.SHIELD_ADVANCED
  }
  case object SECURITY_GROUPS_COMMON
      extends zio.aws.fms.model.SecurityServiceType {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.SecurityServiceType =
      software.amazon.awssdk.services.fms.model.SecurityServiceType.SECURITY_GROUPS_COMMON
  }
  case object SECURITY_GROUPS_CONTENT_AUDIT
      extends zio.aws.fms.model.SecurityServiceType {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.SecurityServiceType =
      software.amazon.awssdk.services.fms.model.SecurityServiceType.SECURITY_GROUPS_CONTENT_AUDIT
  }
  case object SECURITY_GROUPS_USAGE_AUDIT
      extends zio.aws.fms.model.SecurityServiceType {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.SecurityServiceType =
      software.amazon.awssdk.services.fms.model.SecurityServiceType.SECURITY_GROUPS_USAGE_AUDIT
  }
  case object NETWORK_FIREWALL extends zio.aws.fms.model.SecurityServiceType {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.SecurityServiceType =
      software.amazon.awssdk.services.fms.model.SecurityServiceType.NETWORK_FIREWALL
  }
  case object DNS_FIREWALL extends zio.aws.fms.model.SecurityServiceType {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.SecurityServiceType =
      software.amazon.awssdk.services.fms.model.SecurityServiceType.DNS_FIREWALL
  }
  case object THIRD_PARTY_FIREWALL
      extends zio.aws.fms.model.SecurityServiceType {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.SecurityServiceType =
      software.amazon.awssdk.services.fms.model.SecurityServiceType.THIRD_PARTY_FIREWALL
  }
}
