package zio.aws.fms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StatefulEngineOptions(
    ruleOrder: Optional[zio.aws.fms.model.RuleOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.StatefulEngineOptions = {
    import StatefulEngineOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.StatefulEngineOptions
      .builder()
      .optionallyWith(ruleOrder.map(value => value.unwrap))(_.ruleOrder)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.StatefulEngineOptions.ReadOnly =
    zio.aws.fms.model.StatefulEngineOptions.wrap(buildAwsValue())
}
object StatefulEngineOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.StatefulEngineOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.StatefulEngineOptions =
      zio.aws.fms.model.StatefulEngineOptions(ruleOrder.map(value => value))
    def ruleOrder: Optional[zio.aws.fms.model.RuleOrder]
    def getRuleOrder: ZIO[Any, AwsError, zio.aws.fms.model.RuleOrder] =
      AwsError.unwrapOptionField("ruleOrder", ruleOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.StatefulEngineOptions
  ) extends zio.aws.fms.model.StatefulEngineOptions.ReadOnly {
    override val ruleOrder: Optional[zio.aws.fms.model.RuleOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleOrder())
        .map(value => zio.aws.fms.model.RuleOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.StatefulEngineOptions
  ): zio.aws.fms.model.StatefulEngineOptions.ReadOnly = new Wrapper(impl)
}
